/*!
  \file
  \brief Robust Bayesian auto-regression model
  \author Jan Sindelar.
*/

#ifndef ROBUST_H
#define ROBUST_H

#include <stat/exp_family.h>
	
using namespace bdm;
using namespace std;

#include <vector>
class point
{
	vec coordinates;
	point *twinpoint;

public:
	point(vec coordinates);

	point(vec coordinates, point *twinpoint);
};

class segment
{
	point *end1,*end2;

public:
	segment(point *end1, point *end2);
}

class leaf{
	leaf *leftchild,*rightchild,*parent;
	vec condition;
	vector<segment> segments;
	bool deadleaf = false;

public:
	leaf(leaf *parent);	

	evolvechildren(vec condition);
};

//! Conditional(e) Multicriteria-Laplace-Inverse-Gamma distribution density
class emlig : public eEF{
	leaf *tree;

public:
	emlig(leaf *tree) : eEF();	

	emlig(vec [] conditions) : eEF();
	
};

//! Robust Bayesian AR model for Multicriteria-Laplace-Inverse-Gamma density
class RARX : public BMEF{
};


#endif //TRAGE_H
