/*!
\file
\brief wrapper function for arx.structure_est_LT()


 */

#include <stat/emix.h>

using namespace bdm;

#ifdef MEX
#include <estim/arx_ext.h>
#include <estim/kalman.h>
#include <estim/particles.h>
#include <mex/mex_BM.h>
#include <estim/arx.h>

void mexFunction ( int n_output, mxArray *output[], int n_input, const mxArray *input[] ) {
	// Check the number of inputs and output arguments
	if ( n_input<1 ) mexErrMsgTxt ( "Usage:\n"
		                                "arx_struct=arx_structure_reduction(ARX_struct, ARX_prior)\n"
		                                "  ARX_struct = struct('class','ARX',...);            % posterior ARX\n"
		                                "  ARX_prior  = struct('class','ARX',...);            % prior ARX\n"
		                                "output:\n"
		                                "  ARX_struct = struct('class','ARX',...);            % best reduced structure of ARX class." );

	RV::clear_all();
	//CONFIG
	if (n_input<2){			bdm_error("no prior entered"); }
	
	UImxArray Cfg(input[0]);
	UImxArray Cfgpri(input[1]);

	shared_ptr<ARX> A1=UI::build<ARX>(Cfg);
	shared_ptr<ARX> Apri=UI::build<ARX>(Cfgpri);
	
	if ((A1) && (Apri)){	
		
		//if ( n_output<1 ) mexErrMsgTxt ( "No output - nothing to do!" );
		ivec strnew=A1->structure_est_LT(Apri->posterior());
		UImxArray Out;
		A1->reduce_structure(strnew);
		UI::save(A1, Out);
		output[0]=UImxArray::create_mxArray(Out);
	} else { 
		mexErrMsgTxt ( "Given objects are not ARX" );
	}
}
#endif
