clear all

com.class='ARX';
com.yrv = RV({'d'},[2],[0]);
com.rgr = RV({},[],[]);

Data = randn(2,20);

[Mix0,P0]=mixef_init(Data,com);

% show predictor

Pred = bm_epredictor(Mix0);
epdf_2dplot(Pred);

% Do Quasi Bayes

tic
%use same or new data
MixQB = Mix0; 
n = length(MixQB.Coms);
for t=1:size(Data,2)
    log_w_nn = zeros(1,n);
    % get predictions
    for c=1:n
        yt = Data(:,t);
        [dummy, log_w_nn(c)]=bm_bayes(MixQB.Coms{c}, yt);
    end
    % normalize weights
    w = exp(log_w_nn-max(log_w_nn));
    w = w/sum(w);
    
    for c=1:n
        yt = Data(:,t);
        [MixQB.Coms{c}]=bm_bayes(MixQB.Coms{c}, yt);
    end
end
toc

tic
% should be the same as:
% MixQBc = bm_bayes_batch(MixQB,Data);
toc

%% display results

figure(2);
PredQB = bm_epredictor(MixQB);
epdf_2dplot(Pred);

%% relations between components
Batta_dist=zeros(n);
for i=1:n
    for j=i:n
        Batta_dist(i,j) = enorm_bhattacharyya(PredQB.pdfs{i}, PredQB.pdfs{j});
    end
end
imagesc(Batta_dist);