/*
 * @(#)matrix.h    generated by: makeheader 4.21  Tue Jul 26 18:26:13 2005
 *
 *		built from:	../../src/include/copyright.h
 *				../../src/include/pragma_interface.h
 *				./alloccbk.cpp
 *				./alloclst.cpp
 *				./array.cpp
 *				./array2.cpp
 *				./arraycbk.cpp
 *				./arraycpy.cpp
 *				./assignmt.cpp
 *				./bytestr.cpp
 *				./catenate.cpp
 *				./cellindex.cpp
 *				./checkdim.cpp
 *				./conversions.cpp
 *				./end.cpp
 *				./errmsg.cpp
 *				./error.cpp
 *				./fmxapi.cpp
 *				./fmxapiv5.cpp
 *				./funhdl.cpp
 *				./ieee_wrap.cpp
 *				./indexcpy.cpp
 *				./iocbk.cpp
 *				./marshal.cpp
 *				./mcat.cpp
 *				./mxapiv4.cpp
 *				./mxapiv5.cpp
 *				./mxassert.cpp
 *				./mxequal.cpp
 *				./mxutil.cpp
 *				./nameindex.cpp
 *				./nargchk.cpp
 *				./numconv.cpp
 *				./opaque.cpp
 *				./permute.cpp
 *				./populate.cpp
 *				./referenc.cpp
 *				./resize.cpp
 *				./rndcolon.cpp
 *				./scopemgr.cpp
 *				./spassex.cpp
 *				./sprefex.cpp
 *				./strconv.cpp
 *				./subserror.cpp
 *				./transpose.cpp
 *				./txtcmp.cpp
 *				./undoc.cpp
 *				./warning.cpp
 *				./zbuffer.cpp
 *				mxdbg.h
 */

#ifndef matrix_h
#define matrix_h


/*
 * Copyright 1984-2003 The MathWorks, Inc.
 * All Rights Reserved.
 */



/* Copyright 2003-2004 The MathWorks, Inc. */

/*
 * Prevent g++ from making copies of vtable and typeinfo data
 * in every compilation unit.  By allowing for only one, we can
 * save space and prevent some situations where the linker fails
 * to coalesce them properly into a single entry.
 *
 * References:
 *    http://gcc.gnu.org/onlinedocs/gcc/Vague-Linkage.html#Vague%20Linkage
 *    http://gcc.gnu.org/onlinedocs/gcc/C---Interface.html
 */

#ifdef __cplusplus
#  ifdef __linux__
#    pragma interface
#  endif
#endif



#include <stddef.h>	/* size_t */

#ifdef __cplusplus
extern "C" {
#endif
/*
 * allocate memory, notifying registered listener
 */
extern void *mxMalloc(
    size_t	n		/* number of bytes */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * allocate cleared memory, notifying registered listener.
 */
extern void *mxCalloc(
    size_t	n,	/* number of objects */
    size_t	size	/* size of objects */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * free memory, notifying registered listener.
 */
extern void mxFree(void *ptr);	/* pointer to memory to be freed */
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * reallocate memory, notifying registered listener.
 */
extern void *mxRealloc(void *ptr, size_t size);
#ifdef __cplusplus
}
#endif


#if !defined(mxArray_DEFINED)
/*
 * Incomplete definition of mxArray
 */
typedef struct mxArray_tag mxArray;
#define mxArray_DEFINED
#endif /* !defined(mxArray_DEFINED) */


#include "tmwtypes.h"

typedef void(*mxFunctionPtr)(int nlhs, mxArray *plhs[], int nrhs, mxArray *prhs[]);

#define mxMAXNAM  TMW_NAME_LENGTH_MAX	/* maximum name length */

#if !defined(__APPLE__)
typedef bool     mxLogical;
#else
typedef unsigned char mxLogical;
#endif

#ifdef __ENABLE_UNICODE_DATA_REPRESENTATION__
    /* Default is UTF-16 when Unicode rep is enabled. */
    typedef char16_t mxChar;
#else
    /* Default is schizophrenic rep when Unicode is NOT enabled. */
    typedef uint16_T mxChar;
#endif

/*
 * Flipped the position of mxLOGICAL_CLASS and mxOBJECT_CLASS
 * to make sure that mxOBJECT_CLASS is last in the list.
 */
typedef enum {
	mxUNKNOWN_CLASS = 0,
	mxCELL_CLASS,
	mxSTRUCT_CLASS,
	mxLOGICAL_CLASS,
	mxCHAR_CLASS,
	mxVOID_CLASS,
	mxDOUBLE_CLASS,
	mxSINGLE_CLASS,
	mxINT8_CLASS,
	mxUINT8_CLASS,
	mxINT16_CLASS,
	mxUINT16_CLASS,
	mxINT32_CLASS,
	mxUINT32_CLASS,
	mxINT64_CLASS,
	mxUINT64_CLASS,
	mxFUNCTION_CLASS,
        mxOPAQUE_CLASS,
	mxOBJECT_CLASS
} mxClassID;

/* VERY TEMPORARY AND NASTY HACK TILL mxSPARSE_CLASS IS COMPLETELY ELIMINATED */
#define mxSPARSE_CLASS mxVOID_CLASS		/* OBSOLETE! DO NOT USE */

typedef enum {
    mxREAL,
    mxCOMPLEX
} mxComplexity;


#if defined(ARRAY_ACCESS_INLINING) && !defined(MATLAB_COMPILER_GENERATED_CODE)
/*
 * This modified version of the mxArray structure is needed to support
 * the ARRAY_ACCESS_INLINING macros.  NOTE: The elements in this structure
 * should not be accessed directly.  Inlined MEX-files are NOT guaranteed
 * to be portable from one release of MATLAB to another.
 */

struct mxArray_tag {
    void    *reserved;
    int      reserved1[2];
    void    *reserved2;
    int      number_of_dims;
    unsigned int reserved3;
    struct {
        unsigned int    scalar_flag : 1;
	unsigned int	flag1 : 1; 
        unsigned int    flag2 : 1;
        unsigned int    flag3 : 1;
        unsigned int    flag4 : 1;
        unsigned int    flag5 : 1;
        unsigned int    flag6 : 1;
        unsigned int    flag7 : 1;
        unsigned int    private_data_flag : 1;
        unsigned int    flag8 : 1;
        unsigned int    flag9 : 1;
        unsigned int    flag10 : 1;
        unsigned int    flag11 : 4;
        unsigned int    flag12 : 8;
        unsigned int    flag13 : 8;
    }   flags;
    unsigned int reserved4[2];
    union {
        struct {
            void  *pdata;
            void  *pimag_data;
            void  *reserved5;
            int    reserved6[3];
        }   number_array;
    }   data;
};
#endif /* ARRAY_ACCESS_INLINING */

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Return the class (catergory) of data that the array holds.
 */
extern mxClassID mxGetClassID(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get pointer to data
 */
extern void *mxGetData(
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif


#if defined(ARRAY_ACCESS_INLINING)
#define mxGetData(pa)           ((pa)->data.number_array.pdata)
#endif /* defined(ARRAY_ACCESS_INLINING) */

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Set pointer to data
 */
extern void mxSetData(
    mxArray *pa,		/* pointer to array */
    void  *newdata		/* pointer to data */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/* 
 * Determine whether the specified array contains numeric (as opposed 
 * to cell or struct) data.
 */
extern bool mxIsNumeric(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/* 
 * Determine whether the given array is a cell array.
 */
extern bool mxIsCell(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Determine whether the given array's logical flag is on.
 */ 
extern bool mxIsLogical(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*  
 * Determine whether the given array contains character data. 
 */
extern bool mxIsChar(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Determine whether the given array is a structure array.
 */
extern bool mxIsStruct(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Determine whether the given array is an opaque array.
 */
extern bool mxIsOpaque(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Returns true if specified array is a function object.
 */
extern bool mxIsFunctionHandle(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Is array user defined object
 */
extern bool mxIsObject(
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get imaginary data pointer for numeric array
 */
extern void *mxGetImagData(
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif


#if defined(ARRAY_ACCESS_INLINING)
#define mxGetImagData(pa)       ((pa)->data.number_array.pimag_data)
#endif /* defined(ARRAY_ACCESS_INLINING) */

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Set imaginary data pointer for numeric array
 */
extern void mxSetImagData(
    mxArray *pa,		/* pointer to array */
    void    *newdata		/* imaginary data array pointer */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Determine whether the given array contains complex data.
 */
extern bool mxIsComplex(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Determine whether the given array is a sparse (as opposed to full). 
 */
extern bool mxIsSparse(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Determine whether the specified array represents its data as 
 * double-precision floating-point numbers.
 */
extern bool mxIsDouble(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Determine whether the specified array represents its data as 
 * single-precision floating-point numbers.
 */
extern bool mxIsSingle(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Determine whether the specified array represents its data as 
 * signed 8-bit integers.
 */
extern bool mxIsInt8(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Determine whether the specified array represents its data as 
 * unsigned 8-bit integers.
 */
extern bool mxIsUint8(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Determine whether the specified array represents its data as 
 * signed 16-bit integers.
 */
extern bool mxIsInt16(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Determine whether the specified array represents its data as 
 * unsigned 16-bit integers.
 */
extern bool mxIsUint16(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Determine whether the specified array represents its data as 
 * signed 32-bit integers.
 */
extern bool mxIsInt32(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Determine whether the specified array represents its data as 
 * unsigned 32-bit integers.
 */
extern bool mxIsUint32(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Determine whether the specified array represents its data as 
 * signed 64-bit integers.
 */
extern bool mxIsInt64(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Determine whether the specified array represents its data as 
 * unsigned 64-bit integers.
 */
extern bool mxIsUint64(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get number of dimensions in array
 */
extern int mxGetNumberOfDimensions(
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif


#if defined(ARRAY_ACCESS_INLINING)
#define mxGetNumberOfDimensions(pa)  ((pa)->number_of_dims)
#endif /* defined(ARRAY_ACCESS_INLINING) */

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get pointer to dimension array
 */
extern const int *mxGetDimensions(
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/* 
 * Get number of elements in array
 */
extern int mxGetNumberOfElements(	
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get real data pointer for numeric array
 */
extern double *mxGetPr(
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif


#if defined(ARRAY_ACCESS_INLINING)
#define mxGetPr(pa)             ((double *)mxGetData(pa))
#endif /* defined(ARRAY_ACCESS_INLINING) */

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Set real data pointer for numeric array
 */
extern void mxSetPr(
    mxArray *pa,		/* pointer to array */
    double  *pr			/* real data array pointer */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get imaginary data pointer for numeric array
 */
extern double *mxGetPi(
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif


#if defined(ARRAY_ACCESS_INLINING)
#define mxGetPi(pa)             ((double *)mxGetImagData(pa))
#endif /* defined(ARRAY_ACCESS_INLINING) */

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Set imaginary data pointer for numeric array
 */
extern void mxSetPi(
    mxArray *pa,		/* pointer to array */
    double  *pi			/* imaginary data array pointer */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get string array data
 */
extern mxChar *mxGetChars(
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif


#if defined(ARRAY_ACCESS_INLINING)
#define mxGetChars(pa)          ((mxChar *)mxGetData(pa))
#endif /* defined(ARRAY_ACCESS_INLINING) */

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get 8 bits of user data stored in the mxArray header.  NOTE: This state
 * of these bits are not guaranteed to be preserved after API function
 * calls.
 */
extern int mxGetUserBits(
    const mxArray	*pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Set 8 bits of user data stored in the mxArray header. NOTE: This state
 * of these bits are not guaranteed to be preserved after API function
 * calls.
 */ 
extern void mxSetUserBits(
	mxArray	*pa,		/* pointer to array */
	int	value
    );
#ifdef __cplusplus
}
#endif


#ifdef __WATCOMC__
#ifndef __cplusplus
#pragma aux mxGetScalar value [8087];
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get the real component of the specified array's first data element.
 */
extern double mxGetScalar(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Is the isFromGlobalWorkspace bit set?
 */
extern bool mxIsFromGlobalWS(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Set the isFromGlobalWorkspace bit.
 */
extern void mxSetFromGlobalWS(mxArray *pa, bool global);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/* 
 * Get row dimension
 */
extern int mxGetM(
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/* 
 * Set row dimension
 */
extern void mxSetM(
    mxArray *pa,		/* pointer to array */
    int     m			/* row dimension */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/* 
 * Get column dimension
 */
extern int mxGetN(
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Is array empty
 */
extern bool mxIsEmpty(
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get row data pointer for sparse numeric array
 */
extern int *mxGetIr(
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Set row data pointer for numeric array
 */
extern void mxSetIr(
    mxArray *pa,		/* pointer to array */
    int     *newir		/* row data array pointer */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get column data pointer for sparse numeric array
 */
extern int *mxGetJc(
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Set column data pointer for numeric array
 */
extern void mxSetJc(
    mxArray *pa,		/* pointer to array */
    int     *newjc		/* column data array pointer */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get maximum nonzero elements for sparse numeric array
 */
extern int mxGetNzmax(
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Set maximum nonzero elements for numeric array
 */
extern void mxSetNzmax(
    mxArray *pa,		/* pointer to array */
    int     nzmax		/* maximum nonzero elements */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get array data element size
 */
extern int mxGetElementSize(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/* 
 * Return the offset (in number of elements) from the beginning of 
 * the array to a given subscript.  
 */
extern int mxCalcSingleSubscript(const mxArray *pa, int nsubs, const int *subs);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get number of structure fields in array
 */
extern int mxGetNumberOfFields(
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get a pointer to the specified cell element. 
 */ 
extern mxArray *mxGetCell(const mxArray *pa, int i);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Set an element in a cell array to the specified value.
 */
extern void mxSetCell(mxArray *pa, int i, mxArray *value);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Return pointer to the nth field name
 */
extern const char *mxGetFieldNameByNumber(const mxArray *pa, int n);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get the index to the named field.
 */ 
extern int mxGetFieldNumber(const mxArray *pa, const char *name);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Return a pointer to the contents of the named field for 
 * the ith element (zero based).
 */ 
extern mxArray *mxGetFieldByNumber(const mxArray *pa, int i, int fieldnum);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Set pa[i][fieldnum] = value 
 */
extern void mxSetFieldByNumber(mxArray *pa, int i, int fieldnum, mxArray *value);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Return a pointer to the contents of the named field for the ith 
 * element (zero based).  Returns NULL on no such field or if the
 * field itself is NULL
 */
extern mxArray *mxGetField(const mxArray *pa, int i, const char *fieldname);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Set pa[i]->fieldname = value  
 */
extern void mxSetField(mxArray *pa, int i, const char *fieldname, mxArray *value);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/* 
 * Return the name of an array's class.  
 */
extern const char *mxGetClassName(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Determine whether an array is a member of the specified class. 
 */
extern bool mxIsClass(const mxArray *pa, const char *name);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Set scalar double flag
 */
extern void mxSetScalarDoubleFlag(
    mxArray	*pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif


#if defined(ARRAY_ACCESS_INLINING)
#define mxSetScalarDoubleFlag(pa) ((pa)->flags.scalar_flag = true)
#endif /* defined(ARRAY_ACCESS_INLINING) */

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Clear scalar double flag
 */
extern void mxClearScalarDoubleFlag(
    mxArray	*pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif


#if defined(ARRAY_ACCESS_INLINING)
#define mxClearScalarDoubleFlag(pa) ((pa)->flags.scalar_flag = false)
#endif /* defined(ARRAY_ACCESS_INLINING) */

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Is scalar double flag set
 */
extern bool mxIsScalarDoubleFlagSet(
    const mxArray	*pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif


#if defined(ARRAY_ACCESS_INLINING)
#define mxIsScalarDoubleFlagSet(pa) ((pa)->flags.scalar_flag == 1)
#endif /* defined(ARRAY_ACCESS_INLINING) */

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Set scalar flag if appropiate (double scalar)
 */
extern void mxSetScalarDoubleFlagIfAppropiate(
    mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Mark data as unshareable
 */
extern void mxSetDataPrivateFlag(
    mxArray	*pa,		/* pointer to array */
    bool        val
    );
#ifdef __cplusplus
}
#endif


#if defined(ARRAY_ACCESS_INLINING)
#define mxSetDataPrivateFlag(pa, val) ((pa)->flags.private_data_flag = (int)(val))
#endif /* defined(ARRAY_ACCESS_INLINING) */

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Is data unshareable?
 */
extern bool mxIsDataPrivate(
    const mxArray	*pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif


#if defined(ARRAY_ACCESS_INLINING)
#define mxIsDataPrivate(pa)     (((pa)->flags.private_data_flag==1) ? true : false)
#endif /* defined(ARRAY_ACCESS_INLINING) */


#include <stdlib.h>
#define MX_DYNAMIC_STRUCT_REF_ERROR  "Argument to dynamic structure reference must evaluate to a valid field name"

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create a numeric matrix and initialize all its data elements to 0.
 */
extern mxArray *mxCreateNumericMatrix(
	int		m,
	int		n,
	mxClassID	classid,
	int		cmplx_flag
	);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/* 
 * Set column dimension
 */
extern void mxSetN(mxArray *pa, int n);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Set dimension array and number of dimensions.  Returns 0 on success and 1
 * if there was not enough memory available to reallocate the dimensions array.
 */
extern int mxSetDimensions(mxArray *pa, const int *size, int ndims);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * mxArray destructor
 */
extern void mxDestroyArray(mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create a numeric array and initialize all its data elements to 0.
 *
 * Similar to mxCreateNumericMatrix, in a standalone application, 
 * out-of-memory will mean a NULL pointer is returned.
 */
extern mxArray *mxCreateNumericArray(int ndim, const int *dims, mxClassID classid, mxComplexity flag);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create an N-Dimensional array to hold string data;
 * initialize all elements to 0.
 */
extern mxArray *mxCreateCharArray(int ndim, const int *dims);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create a two-dimensional array to hold double-precision
 * floating-point data; initialize each data element to 0.
 */
extern mxArray *mxCreateDoubleMatrix(int m, int n, mxComplexity flag);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Get a properly typed pointer to the elements of a logical array.
 */
extern mxLogical *mxGetLogicals(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create a logical array and initialize its data elements to false.
 */
extern mxArray *mxCreateLogicalArray(int ndim, const int *dims);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create a two-dimensional array to hold logical data and
 * initializes each data element to false.
 */
extern mxArray *mxCreateLogicalMatrix(unsigned int m, unsigned int n);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create a logical scalar mxArray having the specified value.
 */
extern mxArray *mxCreateLogicalScalar(bool value);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Returns true if the logical scalar value is true.
 */
extern bool mxIsLogicalScalarTrue(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create a double-precision scalar mxArray initialized to the
 * value specified
 */
extern mxArray *mxCreateDoubleScalar(double value);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create a 2-Dimensional sparse array.
 */
extern mxArray *mxCreateSparse(int m, int n, int nzmax, mxComplexity flag);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create a 2-D sparse logical array
 */
extern mxArray *mxCreateSparseLogicalMatrix(int m, int n, int nzmax);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Copies characters from a MATLAB array to a char array
 * This function will attempt to perform null termination if it is possible.
 * nChars is the number of bytes in the output buffer
 */
extern void mxGetNChars(const mxArray *pa, char *buf, int nChars);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Converts a string array to a C-style string. The C-style string is in the
 * local codepage encoding. If the conversion for the entire Unicode string
 * cannot fit into the supplied character buffer, then the conversion includes
 * the last whole codepoint that will fit into the buffer. The string is thus
 * truncated at the greatest possible whole codepoint and does not split code-
 * points.
 */
extern int mxGetString(const mxArray *pa, char *buf, int buflen);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create a NULL terminated C string from an mxArray of type mxCHAR_CLASS
 * Supports multibyte character sets.  The resulting string must be freed
 * with mxFree.  Returns NULL on out of memory or non-character arrays.
 */
extern char *mxArrayToString(const mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create a 1-by-n string array initialized to str. The supplied string is
 * presumed to be in the local codepage encoding. The character data format
 * in the mxArray will be UTF-16.
 */
extern mxArray *mxCreateStringFromNChars(const char *str, int n);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create a 1-by-n string array initialized to null terminated string
 * where n is the length of the string.
 */
extern mxArray *mxCreateString(const char *str);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create a string array initialized to the strings in str.
 */
extern mxArray *mxCreateCharMatrixFromStrings(int m, const char **str);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create a 2-Dimensional cell array, with each cell initialized
 * to NULL.
 */
extern mxArray *mxCreateCellMatrix(int m, int n);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create an N-Dimensional cell array, with each cell initialized
 * to NULL.
 */
extern mxArray *mxCreateCellArray(int ndim, const int *dims);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create a 2-Dimensional structure array having the specified fields;
 * initialize all values to NULL.
 */
extern mxArray *mxCreateStructMatrix(int m, int n, int nfields, const char **fieldnames);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Create an N-Dimensional structure array having the specified fields;
 * initialize all values to NULL.
 */
extern mxArray *mxCreateStructArray(int ndim, const int *dims, int nfields,
								const char **fieldnames);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Make a deep copy of an array, return a pointer to the copy.
 */
extern mxArray *mxDuplicateArray(const mxArray *in);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Set classname of an unvalidated object array.  It is illegal to
 * call this function on a previously validated object array.
 * Return 0 for success, 1 for failure.
 */
extern int mxSetClassName(mxArray *pa, const char *classname);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/* 
 * Add a field to a structure array. Returns field number on success or -1
 * if inputs are invalid or an out of memory condition occurs.
 */
extern int mxAddField(mxArray *pa, const char *fieldname);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Remove a field from a structure array.  Does nothing if no such field exists.
 * Does not destroy the field itself.
*/
extern void mxRemoveField(mxArray *pa, int field);
#ifdef __cplusplus
}
#endif


#ifdef __WATCOMC__
#ifndef __cplusplus
#pragma aux mxGetEps value [8087];
#pragma aux mxGetInf value [8087];
#pragma aux mxGetNaN value [8087];
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Function for obtaining MATLAB's concept of EPS
 */
extern double mxGetEps(void);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Function for obtaining MATLAB's concept of INF (Used in MEX-File callback).
 */
extern double mxGetInf(void);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * Function for obtaining MATLAB's concept of NaN (Used in MEX-File callback).
 */
extern double mxGetNaN(void);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * test for finiteness in a machine-independent manner
 */
extern bool mxIsFinite(
    double x                  /* value to test */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * test for infinity in a machine-independent manner
 */
extern bool mxIsInf(
    double x                  /* value to test */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * test for NaN in a machine-independent manner
 */
extern bool mxIsNaN(
    double x                  /* value to test */
    );
#ifdef __cplusplus
}
#endif


#define mxCreateFull() mxCreateFull_is_obsolete
#define mxIsFull()     mxIsFull_is_obsolete
#define mxIsString()   mxIsString_is_obsolete
#define mxFreeMatrix() mxFreeMatrix_is_obsolete


#define mxCreateScalarDouble(d) mxCreateDoubleScalar(d)

#if defined(V5_COMPAT)

#ifdef __cplusplus
extern "C" {
#endif
/*
 * NOTE: This function is obsolete and should no longer be used. Please
 *       use one of the following routines instead:
 *                         mxCreateLogicalScalar
 *                         mxCreateLogicalMatrix
 *                         mxCreateLogicalArray
 *
 * Specify that the data in an array is to be treated as Boolean data.
 */
extern void mxSetLogical(mxArray *pa);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*
 * NOTE: This function is obsolete and should no longer be used.
 *
 * Specify that the data in an array is to be treated as numerical
 * (as opposed to Boolean) data. 
 */
extern void mxClearLogical(mxArray *pa);
#ifdef __cplusplus
}
#endif


#else
#define mxSetLogical()     mxSetLogical_is_obsolete
#define mxClearLogical()   mxClearLogical_is_obsolete
#endif /* defined(V5_COMPAT) */


#if defined(V5_COMPAT)

#ifdef __cplusplus
extern "C" {
#endif
/* 
 * Get pointer to array name.
 */
extern const char *mxGetName(
    const mxArray *pa		/* pointer to array */
    );
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
/* 
 * Set array name.  This routine copies the string pointed to by s
 * into the mxMAXNAM length character name field.
 */
extern void mxSetName(
    mxArray    *pa,		/* pointer to array */
    const char *s		/* string to copy into name */
    );
#ifdef __cplusplus
}
#endif


#else
#define mxGetName()     mxGetName_is_obsolete
#define mxSetName()     mxSetName_is_obsolete
#endif /* defined(V5_COMPAT) */



/*
mxAssert(int expression, char *error_message)
---------------------------------------------

  Similar to ANSI C's assert() macro, the mxAssert macro checks the
  value of an assertion, continuing execution only if the assertion
  holds.  If 'expression' evaluates to be true, then the mxAssert does
  nothing.  If, however, 'expression' is false, then mxAssert prints an
  error message to the MATLAB Command Window, consisting of the failed
  assertion's expression, the file name and line number where the failed
  assertion occurred, and the string 'error_message'.  'error_message'
  allows the user to specify a more understandable description of why
  the assertion failed.  (Use an empty string if no extra description
  should follow the failed assertion message.)  After a failed
  assertion, control returns to the MATLAB command line. 

  mxAssertS, (the S for Simple), takes the same inputs as mxAssert.  It 
  does not print the text of the failed assertion, only the file and 
  line where the assertion failed, and the explanatory error_message.

  Note that script MEX will turn off these assertions when building
  optimized MEX-functions, so they should be used for debugging 
  purposes only.
*/

#ifdef MATLAB_MEX_FILE
#  ifndef NDEBUG
extern
#    ifdef __cplusplus
       "C"
#    endif
void mexPrintAssertion(const char *test, 
		       const char *fname, 
		       int linenum, 
		       const char *message);

#    define mxAssert(test, message) ( (test) ? (void) 0 : mexPrintAssertion(": " #test ",", __FILE__, __LINE__, message))
#    define mxAssertS(test, message) ( (test) ? (void) 0 : mexPrintAssertion("", __FILE__, __LINE__, message))
#  else
#    define mxAssert(test, message) ((void) 0)
#    define mxAssertS(test, message) ((void) 0)
#  endif
#else
#  include <assert.h>
#  define mxAssert(test, message) assert(test)
#  define mxAssertS(test, message) assert(test)
#endif



#include <stdlib.h>


/* $Revision: 1.14.4.1 $ */
#ifdef ARGCHECK

#include "mwdebug.h" /* Prototype _d versions of API functions */

#define mxAddField(pa, fieldname)                       mxAddField_d(pa, fieldname, __FILE__, __LINE__)
#define mxArrayToString(pa)				mxArrayToString_d(pa, __FILE__, __LINE__)
#define mxCalcSingleSubscript(pa, nsubs, subs)          mxCalcSingleSubscript_d(pa, nsubs, subs, __FILE__, __LINE__) 
#define mxCalloc(nelems, size)                          mxCalloc_d(nelems, size, __FILE__, __LINE__)
#define mxCreateCellArray(ndim, dims)	                mxCreateCellArray_d(ndim, dims, __FILE__, __LINE__)
#define mxCreateCellMatrix(m, n)                        mxCreateCellMatrix_d(m, n, __FILE__, __LINE__)
#define mxCreateCharArray(ndim, dims)                   mxCreateCharArray_d(ndim, dims, __FILE__, __LINE__)
#define mxCreateCharMatrixFromStrings(m, strings)       mxCreateCharMatrixFromStrings_d(m, strings, __FILE__, __LINE__)
#define mxCreateDoubleMatrix(m, n, cplxflag)		mxCreateDoubleMatrix_d(m, n, cplxflag, __FILE__, __LINE__)
#define mxCreateDoubleScalar(value)		        mxCreateDoubleScalar_d(value, __FILE__, __LINE__)
#define mxCreateLogicalArray(ndim, dims)		mxCreateLogicalArray_d(ndim, dims, __FILE__, __LINE__)
#define mxCreateLogicalMatrix(m, n)		        mxCreateLogicalMatrix_d(m, n, __FILE__, __LINE__)
#define mxCreateLogicalScalar(value)	                mxCreateLogicalScalar_d(value, __FILE__, __LINE__)
#define mxCreateNumericArray(ndim, dims, classname, cplxflag) mxCreateNumericArray_d(ndim, dims, classname, cplxflag, __FILE__, __LINE__) 
#define mxCreateNumericMatrix(m, n, classid, cmplx_flag)      mxCreateNumericMatrix_d(m, n, classid, cmplx_flag, __FILE__, __LINE__)
#define mxCreateSparse(m, n, nzmax, cplxflag)           mxCreateSparse_d(m, n, nzmax, cplxflag, __FILE__, __LINE__) 
#define mxCreateSparseLogicalMatrix(m, n, nzmax)	mxCreateSparseLogicalMatrix_d(m, n, nzmax, __FILE__, __LINE__)
#define mxCreateString(string) mxCreateString_d(string, __FILE__, __LINE__)
#define mxCreateStructArray(ndim, dims, nfields, fieldnames)  mxCreateStructArray_d(ndim, dims, nfields, fieldnames, __FILE__, __LINE__)
#define mxCreateStructMatrix(m, n, nfields, fieldnames) mxCreateStructMatrix_d(m, n, nfields, fieldnames, __FILE__, __LINE__)
#define mxDestroyArray(pa)				mxDestroyArray_d(pa, __FILE__, __LINE__)
#define mxDuplicateArray(pa)			        mxDuplicateArray_d(pa, __FILE__, __LINE__)
#define mxFree(pm)					mxFree_d(pm, __FILE__, __LINE__)
#define mxGetChars(pa)					mxGetChars_d(pa, __FILE__, __LINE__)
#define mxGetCell(pa, index)			        mxGetCell_d(pa, index, __FILE__, __LINE__)
#define mxGetClassID(pa)				mxGetClassID_d(pa, __FILE__, __LINE__)
#define mxGetClassName(pa)				mxGetClassName_d(pa, __FILE__, __LINE__)
#define mxGetData(pa)                                   mxGetData_d(pa, __FILE__, __LINE__)
#define mxGetDimensions(pa)  			        mxGetDimensions_d(pa, __FILE__, __LINE__)
#define mxGetElementSize(pa)			        mxGetElementSize_d(pa, __FILE__, __LINE__)
#define mxGetField(pa, index, fieldname)                mxGetField_d(pa, index, fieldname, __FILE__, __LINE__)
#define mxGetFieldByNumber(pa, index, fieldnum)         mxGetFieldByNumber_d(pa, index, fieldnum, __FILE__, __LINE__)
#define mxGetFieldNameByNumber(pa, fieldnum)            mxGetFieldNameByNumber_d(pa, fieldnum, __FILE__, __LINE__)
#define mxGetFieldNumber(pa, fieldname)                 mxGetFieldNumber_d(pa, fieldname, __FILE__, __LINE__)
#define mxGetImagData(pa)                               mxGetImagData_d(pa, __FILE__, __LINE__)
#define mxGetIr(pa)                                     mxGetIr_d(pa, __FILE__, __LINE__)
#define mxGetJc(pa)                                     mxGetJc_d(pa, __FILE__, __LINE__)
#define mxGetLogicals(pa)				mxGetLogicals_d(pa, __FILE__, __LINE__)
#define mxGetNumberOfDimensions(pa)		        mxGetNumberOfDimensions_d(pa, __FILE__, __LINE__)
#define mxGetNumberOfElements(pa)		        mxGetNumberOfElements_d(pa, __FILE__, __LINE__)
#define mxGetNumberOfFields(pa)			        mxGetNumberOfFields_d(pa, __FILE__, __LINE__)
#define mxGetNzmax(pa)					mxGetNzmax_d(pa, __FILE__, __LINE__)
#define mxGetM(pa)					mxGetM_d(pa, __FILE__, __LINE__)
#define mxGetN(pa)					mxGetN_d(pa, __FILE__, __LINE__)
#define mxGetPi(pa)                                     mxGetPi_d(pa, __FILE__, __LINE__)
#define mxGetPr(pa)                                     mxGetPr_d(pa, __FILE__, __LINE__)
#define mxGetScalar(pa)					mxGetScalar_d(pa, __FILE__, __LINE__)
#define mxGetString(pa, buffer, buflen)                 mxGetString_d(pa, buffer, buflen, __FILE__, __LINE__)
#define mxIsCell(pa)					mxIsCell_d(pa, __FILE__, __LINE__)
#define mxIsChar(pa)					mxIsChar_d(pa, __FILE__, __LINE__)
#define mxIsClass(pa, classname)                        mxIsClass_d(pa, classname, __FILE__, __LINE__)
#define mxIsComplex(pa)					mxIsComplex_d(pa, __FILE__, __LINE__)
#define mxIsDouble(pa)					mxIsDouble_d(pa, __FILE__, __LINE__)
#define mxIsEmpty(pa)					mxIsEmpty_d(pa, __FILE__, __LINE__)
#define mxIsFromGlobalWS(pa)                            mxIsFromGlobalWS_d(pa, __FILE__, __LINE__)
#define mxIsInt8(pa)					mxIsInt8_d(pa, __FILE__, __LINE__)
#define mxIsInt16(pa)					mxIsInt16_d(pa, __FILE__, __LINE__)
#define mxIsInt32(pa)					mxIsInt32_d(pa, __FILE__, __LINE__)
#define mxIsLogical(pa)					mxIsLogical_d(pa, __FILE__, __LINE__)
#define mxIsNumeric(pa)					mxIsNumeric_d(pa, __FILE__, __LINE__)
#define mxIsOpaque(pa)					mxIsOpaque_d(pa, __FILE__, __LINE__)
#define mxIsObject(pa)					mxIsObject_d(pa, __FILE__, __LINE__)
#define mxIsSingle(pa)					mxIsSingle_d(pa, __FILE__, __LINE__)
#define mxIsSparse(pa)					mxIsSparse_d(pa, __FILE__, __LINE__)
#define mxIsStruct(pa)					mxIsStruct_d(pa, __FILE__, __LINE__)
#define mxIsUint8(pa)					mxIsUint8_d(pa, __FILE__, __LINE__)
#define mxIsUint16(pa)					mxIsUint16_d(pa, __FILE__, __LINE__)
#define mxIsUint32(pa)					mxIsUint32_d(pa, __FILE__, __LINE__)
#define mxIsUint64(pa)				        mxIsUint64_d(pa, __FILE__, __LINE__)
#define mxMalloc(n)			                mxMalloc_d(n, __FILE__, __LINE__)
#define mxRealloc(pm, nelems)			        mxRealloc_d(pm, nelems, __FILE__, __LINE__)
#define mxRemoveField(pa, field)		        mxRemoveField_d(pa, field, __FILE__, __LINE__)
#if !defined(MATLAB_MEX_FILE)
#define mxSetAllocFcns(callocptr, freeptr, reallocptr, mallocptr) mxSetAllocFcns_d(callocptr, freeptr, reallocptr, freeptr, __FILE__, __LINE__)
#endif /* MATLAB_MEX_FILE */
#define mxSetCell(pa, index, value)		        mxSetCell_d(pa, index, value, __FILE__, __LINE__)
#define mxSetClassName(pa, name)		        mxSetClassName_d(pa, name, __FILE__, __LINE__)
#define mxSetData(pa, pd)				mxSetData_d(pa, pd, __FILE__, __LINE__)
#define mxSetDimensions(pa, size, ndims)                mxSetDimensions_d(pa, size, ndims, __FILE__, __LINE__)
#define mxSetField(pa, index, fieldname, value)         mxSetField_d(pa, index, fieldname, value, __FILE__, __LINE__)
#define mxSetFieldByNumber(pa, index, fieldnum, value)  mxSetFieldByNumber_d(pa, index, fieldnum, value, __FILE__, __LINE__)
#define mxSetImagData(pa, pid)			        mxSetImagData_d(pa, pid, __FILE__, __LINE__)
#define mxSetIr(pa, ir)					mxSetIr_d(pa, ir, __FILE__, __LINE__)
#define mxSetJc(pa, jc)					mxSetJc_d(pa, jc, __FILE__, __LINE__)
#define mxSetM(pa, m)				        mxSetM_d(pa, m, __FILE__, __LINE__)
#define mxSetN(pa, n)				        mxSetN_d(pa, n, __FILE__, __LINE__)
#define mxSetNzmax(pa, nzmax)			        mxSetNzmax_d(pa, nzmax, __FILE__, __LINE__)
#define mxSetPi(pa, pi)					mxSetPi_d(pa, pi, __FILE__, __LINE__)
#define mxSetPr(pa, pr)					mxSetPr_d(pa, pr, __FILE__, __LINE__)
#endif

#endif /* matrix_h */
