function [box zero range eigvec]=make_box4(points)
%OK
N=size(points,1);
dim=size(points,2);
num_of_points=round(N^(1/dim));

meanval=mean(points,1);
[eigvec,eigval]=eig((points-ones(N,1)*meanval)'*(points-ones(N,1)*meanval));
range=2*sqrt(diag(eigval)/N);

box=zeros(N,dim);
pointer=-range;
step=2*range/(num_of_points-1);
jump=[1 num_of_points num_of_points^2];
%plot3(points(:,1), points(:,2), points(:,3),'r.' ); hold on
for i=1:N
    for k=1:dim
        box(i,k)=pointer(k)+step(k)*mod(floor((i-1)/jump(k)),num_of_points);
    end
    %plot3(box(:,1), box(:,2), box(:,3),'b.' )
end  

box=(box)*eigvec'+ones(N,1)*meanval;
range=ones(dim,1)./(2*range);
zero=box(1,:);
%plot3(box(:,1), box(:,2), box(:,3),'b.' );
plot(box(:,1), box(:,2),'b.' ); hold on
plot(points(:,1), points(:,2), 'r.' ); hold off

end
