classdef mexDirac < mexEpdf
    % Dirac delta probability distribution
    properties                                                 % DATA structures
        point                                                  % point of the support
    end
    methods
        function m=mean(obj)                                   % compute mean values of the density
            m = obj.point;
        end
        function obj=validate(obj)                             % check if data structures are consistent
            % point should be a column
            if (size(obj.point,2)>1)
                if (size(obj.point,1)==1) % it is row
                    obj.point = obj.point';
                end
            else
                error('Point in mexDirac is not a vector');
            end
        end
        function dim=dimension(obj)                            % inform others about your dimensions
            dim = size(obj.point,1);
        end
        function v=variance(obj)                               % compute variance
            v=zeros(size(obj.point));
        end
        function l=evallog(obj,x)                              % return logarithm of your density at point x
            if obj.point==x
                l = inf;
            else
                l=0;
            end
        end
        function s=sample(obj);                                % return random sample from your density
            s = obj.point;
        end
    end
end