#ifndef MXFNC_H
#define MXFNC_H


#include <base/bdmbase.h>
#include "mex_parser.h"

namespace bdm {

	/*! class mapping fnc.eval to call of matlab function via mexCallMatlab
	*/
	class mexFnc: public fnc{
		protected:
		string fname;
		public:
			vec eval(const vec &cond){
				mxArray *mxinp = mxCreateDoubleMatrix ( cond.length(), 1, mxREAL );
				mxArray *mxout;
				
				vec2mxArray(cond,mxinp);
				mexCallMATLAB ( 1, &mxout, 1, &mxinp, fname.c_str() );
				
				bdm_assert(int(mxGetN(mxout))==(dimension()) || int(mxGetM(mxout))==(dimension()), "vector length mismatch");
				vec tmp=mxArray2vec(mxout);
				return tmp;
			}
			/*! 
			\code
			function = 'matlab_function_name';
			\endcode
			*/
			void from_setting(const Setting &set){
				fnc::from_setting(set);
				UI::get(fname, set, "function", UI::compulsory);
			}
			void to_setting(Setting &set) const {
				fnc::to_setting(set);
				UI::save(fname, set, "function");
			}
	};
	UIREGISTER(mexFnc);
}
#endif //MXFNC_H
