/*!
  \file
  \brief Support for test suits.
  \author Miroslav Pistek.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef GENERAL_SUITE_H
#define GENERAL_SUITE_H

#include "Test.h"
#include "TestReporterStdout.h"
#include "UnitTest++.h"
#include "bdmerror.h"
#include "itpp_ext.h"
#include <string.h>

using std::cout;
using std::cerr;
using std::endl;

using namespace itpp;

namespace UnitTest {

void print_test_list();

void pick_selected_tests ( int argc, char const *argv[] );

int run_selected_tests();

}

#endif
