function pwm(compute)
if nargin<1, 
    compute=1;
end

if compute
    M=pmsm_estim_mex('pwm_mx.cfg');
    save pwm M
else
    load pwm
end

time =0.000125*[0:size(M.xia,1)-1];

%%%%%%%%%%%%%% U
figure(1);
detail=14000:20000;
% ua
subplot(2,2,1);
plot(time(detail),M.oua(detail)-M.tua(detail));
title('Difference between simulated and non-compensated observed u_{s,\alpha} (detail)')

subplot(2,2,2);
hist(M.oua-M.tua,30);
title('Histogram of difference on the full data record of 8s')

%ub
subplot(2,2,3);
plot(time(detail),M.modelua(detail)-M.tua(detail));
title('Difference between simulated and compensated observed u_{s,\alpha} (detail)')

subplot(2,2,4);
hist(M.modelua-M.tua,30);
title('Histogram of difference on the full data record of 8s')

dt=0.000125;
Ls=0.003465; 

bnds = [max(abs(M.modelua-M.tua)), max(abs(M.modelub-M.tub)) 0 0];
Qpwm = (dt/Ls)^2*[1 1 0 0]%(2*bnds).^2/12

figure(3);
plot(M.xom);

%%%%%%%%%%%%%%% Integration

figure(2)
subplot(4,2,1); plot(time,M.erria);xlabel('time [s]');
title('Integration error on state variables')
ylabel('Error on i_{s,\alpha}')
subplot(4,2,2); hist(M.erria,30);
title('Histogram of errors on state variables')

subplot(4,2,3); plot(time,M.errib);xlabel('time [s]');
ylabel('Error on i_{s,\beta}')
subplot(4,2,4); hist(M.errib,30);
%title('Histogram of error on i_{s,\beta}')

subplot(4,2,5); plot(time,M.errom);xlabel('time [s]');
ylabel('Error on \omega_{me}')
subplot(4,2,6); hist(M.errom,30);
%title('Histogram of error on \omega_{me}')

subplot(4,2,7); plot(time,M.errth); xlabel('time [s]');
ylabel('Error on \vartheta_{me}')
subplot(4,2,8); hist(M.errth,30);
%title('Histogram of error on \vartheta_{me}')

Qint=[var(M.erria), var(M.errib), var(M.errom), var(M.errth)]

bnds=[max(abs(M.erria)), max(abs(M.errib)), max(abs(M.errom)), max(abs(M.errth))]
Qint = [(2*bnds).^2/12]

%%%%%%%%%%%%%%%% Mz prop
Fmag= 0.1989; 
p = 4.0;
J = 0.04;   

Tl=10;
dom = p/J*Tl*dt
Qrat=(2*[Fmag/Ls*dt,Fmag/Ls*dt, 1, dt]).^2/12

Qtot=Qpwm+Qint
Qtot+Qrat

%%%%%%%%%%%%%%%% R
R=(2*0.085)^2/12*[1 1]