#include <itpp/itbase.h>
#include "loggers.h"
#include "../osutils.h"

#include <fcntl.h>
#ifdef WIN32
#include <io.h>
#endif

void memlog::itsave(const char* fname){
	it_file itf(fname);
	int i;
	for (i=0; i<entries.length();i++){
	 itf << Name(names(i)) << vectors(i);
	}
}

void dirfilelog::init() {
	int i,j,k;
	int nsc=0;
	for ( i=0;i<entries.length();i++ ) {nsc+=entries ( i ).count();}
	; //all entries!!

	char filename[200];
	char num[3];

// Initialize directory
	makedir(dirname); // 

// directory OK, or it can be overwritten

//Create filenames
	scalarnames.set_length ( nsc );
	// For all entries
	int ii=0;
	for ( i=0;i<entries.length();i++ ) { //for entries
		for ( j=0;j<entries ( i ).length();j++ ) { //for RVs in entries
			int rvsize = entries ( i ).size ( j );
			if ( rvsize ==1 ) {
				scalarnames ( ii ) = names ( i ) + "_" + entries ( i ).name ( j );
				ii++;
			} else {
				for ( k=0;k<rvsize;k++ ) { //for all scalars in given RV
					sprintf ( num,"%d",k );
					scalarnames ( ii ) = names ( i ) + "_" + entries ( i ).name ( j ) + "_" + num;
					ii++;
				}
			}
		}
	}
	//Create format
	string frm="format";
	get_fname ( filename, dirname, frm );

	FILE* fpf;
	fpf = fopen ( filename, "w" );
	for ( i=0;i<ii;i++ ) {
		fprintf ( fpf, "%s RAW d 1\n", scalarnames ( i ).c_str() );
	}
	fclose ( fpf );

	memlog::init();

	write_buffers ( 0 );
}


void dirfilelog::write_buffers ( int Len ) {
	int fp;
	int nen=entries.length(); //all entries!!
	double *Dt;
	int DtRows;
	int i,j,k;
	int ii; //index in scalarnames;
	int jj; //index in vectors()
	char filename[200];

	it_assert_debug ( Len<=maxlen,"diffilelog" );

	ii = 0;
	for ( i=0;i<nen;i++ ) { //for entries
		Dt = vectors ( i )._data();
		DtRows = vectors(i).rows();
		
		jj=0;
		for ( j=0;j<entries ( i ).length();j++ ) { //for RVs in entries
			int rvsize = entries ( i ).size ( j );
			for ( k=0;k<rvsize;k++ ) { { //for all scalars in given RV
					get_fname ( filename,dirname,scalarnames ( ii ) );
					if ( Len==0 ) //initialization
						fp = open ( filename, O_CREAT | O_WRONLY | O_TRUNC, 00644 );
					else
						fp = open ( filename, O_CREAT | O_WRONLY | O_APPEND, 00644 );

					write ( fp,&Dt[jj*(DtRows)],(Len)*sizeof ( double ) );
					close ( fp );

					//next row in Dt
					jj++;
					//next scalarname
					ii++;
				}
			}
		}
	}
}

void dirfilelog::step ( bool final ) {

	if ( final ) {
		if ( ind>0 )
			write_buffers ( ind ); //assuming here that i+1 was not filled
	} else
		if ( ind== ( maxlen -1 ) ) {
			write_buffers ( ind+1 );
			ind = 0;
		} else
			ind++;

}
