% script for estimation of Mz
addpath ~/work/git/mixpp/library/mex/
addpath ~/work/git/mixpp/applications/pmsm/

dQ=[0.017, 0.017, 0.00000004, 1e-14, 1e-3];
dR=[0.025, 0.025];

% experiment
S.experiment.ndat = 32000;

Orv.type  = 'rv';
Orv.names = { 'X' };
Orv.sizes = [ 4 ];

Oekf.type = 'rv';

S.system= struct('type', 'ITppFileDS',...
    'filename','tec0013ALL.it',...
    'varname','D',...
    'rv', Orv);

S.estimator = {struct('type','EKF',...
	 'IM', struct('type','pmsmIM',...
		'params', struct('type', 'external', 'filename', '../cfg/zcu.cfg','path' ,'pmsm107'),...
        'variant', 'Mz'),...
	 'OM', struct('type','pmsmOM'),...
	 'dQ',dQ,...
	 'dR',dR,...
	 'dP0',[1., 1., 1., 10., 1e-10],...
    'drv', Orv,...
    'rv', struct('type','rv', 'names', {{'EKFMz'}},'sizes',[5]),...
	 'log_level','logevidence,logbounds')};
	
%S.logger= struct(	'type','mexlog','maxlen',32000);
S.logger= struct(	'type','dirfilelog','maxlen',32000,'dirname','t2');

%pmsm_estim_mex(S)
