% Random Variables
a=RV('a');
b=RV('b');
ab=RV({'a','b'});

% Sources
f1.class= 'enorm<ldmat>';
f1.mu   = 3;
f1.R    = 1;
f1.rv   = a;

f2 = struct('class','enorm<ldmat>',...
    'mu',-3,...
    'R',  2,...
    'rv', a);


% merger 
M.class='merger_mix';
M.method='lognormal';
M.beta=2;
M.ncoms=20;
M.stop_niter=5;
M.effss_coef=1;
%merger.dbg_file='merger_mix_dbg';

% support
support.class='rectangular_support';
support.ranges={[-5,5]};
support.gridsizes=[100];

% 1D
[vy]=merger({f1,f2},support,M)
figure(1)
hold off
plot(vy.support,vy.weights,'.')
hold on
plot(vy.support,vy.source1,'.r')
plot(vy.support,vy.source2,'.r')

% wx=vy.weights;
% [n,x]=hist(wx,15);
% bar(x,(n.*wx)/sum(n.*wx));

% 2D sources
f3 = struct('class','enorm<ldmat>',...
    'mu',[1,2],...
    'R',  [2 0; 0 1.5],...
    'rv', ab);
f4 = struct('class','egiw',...
    'fV',4*[5 2; 2 1],...
    'nu',  4,...
    'dimx',  1,...
    'rv', ab);
% 2D support
support2.class='rectangular_support';
support2.ranges={[-5,5],[0.001,5]};
support2.gridsizes=[20,20];

% 2D
vy2=merger({f3,f4},support2,M)
X=zeros(support2.gridsizes(1));
Y=zeros(support2.gridsizes(1));
Z=zeros(support2.gridsizes(1));

figure(2);
subplot(1,3,1);
hold off
plot(vy2.support(1,:),vy2.support(2,:),'.','MarkerSize',4)
hold on
contour_2(vy2.support(1,:),vy2.support(2,:),vy2.weights)
subplot(1,3,2);
contour_2(vy2.support(1,:),vy2.support(2,:),vy2.source1)
subplot(1,3,3);
contour_2(vy2.support(1,:),vy2.support(2,:),vy2.source2)