#include "emix.h"

using namespace itpp;

void emix::set_parameters ( const vec &w0, const Array<epdf*> &Coms0 ){
	w = w0;
	int i;
	for(i=0;i<w.length();i++){it_assert_debug(rv.equal(Coms0(i)->_rv()),"RVs do not match!"); }
	Coms = Coms0;
}

vec emix::sample() const{
	//Sample which component 
	vec cumDist = cumsum ( w );
	double u0 = UniRNG.sample();

	int i=0;
	while ((w(i)<u0) && (i<(w.length()-1))){i++;}
	
	return Coms(i)->sample();
}
