/*!
  \file
  \brief Probability distributions for Mixtures of pdfs
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef MX_H
#define MX_H

#include "libBM.h"
#include "libEF.h"
//#include <std>

using namespace itpp;

/*!
* \brief Mixture of epdfs

Density function:
\f[
f(x) = \sum_{i=1}^{n} w_{i} f_i(x), \quad \sum_{i=1}^n w_i = 1.
\f]
where \f$f_i(x)\f$ is any density on random variable \f$x\f$, called \a component,

*/
class emix : public epdf {
protected:
	//! weights of the components
	vec w;
	//! Component (epdfs)
	Array<epdf*> Coms;
public:
	//!Default constructor
	emix ( RV &rv ) : epdf ( rv ) {};
	//! Set weights \c w and components \c R
	void set_parameters ( const vec &w, const Array<epdf*> &Coms );

	vec sample() const;
	vec mean() const {
		int i; vec mu=zeros ( rv.count() );
		for ( i=0;i<w.length();i++ ) {mu+=w ( i ) *Coms ( i )->mean(); }
		return mu;
	}
	double evalpdflog ( const vec &val ) const {int i; double sum=0.0; for ( i=0;i<w.length();i++ ) {sum+=w ( i ) *Coms ( i )->evalpdflog ( val );} return log ( sum );};

//Access methods
	//! returns a pointer to the internal mean value. Use with Care!
	vec& _w() {return w;}
};

class mmix_triv : public mpdf {
public:
	//!Default constructor
	mmix_triv ( const RV &rv, const RV &rvc, emix* em ) :mpdf ( rv,rvc ) {ep=em;};
};

#endif //MX_H
