/*!
\file
\brief wrapper function for epdf.evallog_mat()


 */

#include <stat/emix.h>

using namespace bdm;

#ifdef MEX
#include <mex/mex_parser.h>
#include <mex/mex_pdf.h>

void mexFunction ( int n_output, mxArray *output[], int n_input, const mxArray *input[] ) {
	// Check the number of inputs and output arguments
	if ( n_input<1 ) mexErrMsgTxt ( "Usage:\n"
		                                "mat=pdf_evallog_mat(pdf_struct, nos)\n"
		                                "  pdf_struct = struct('class','pdf_offspring',...);      % description of pdf\n"
		                                "  points     = pdf_dimension x npoints matrix;           % points in which to evaluate\n"
		                                "output:\n"
		                                "  vector of log-likelihoods" );

	RV::clear_all();
	//CONFIG
	if (n_input<2) mexErrMsgTxt("evaluation points are not given");
	UImxArray Cfg(input[0]);
	shared_ptr<epdf> ep=UI::build<epdf>(Cfg);
	
	int nop, dim;
	nop = mxGetN(input[1]);
	dim = mxGetM(input[1]);
	if (dim != ep->dimension()) {
		string msg="pdf is of dimension " + num2str(ep->dimension()) + "size of data points is " + num2str(dim);
		mexErrMsgTxt(msg.c_str()); 
	}
	
	output[0] = mxCreateDoubleMatrix(nop, 1, mxREAL);
	mat points = mxArray2mat(input[1]);
	vec v=ep->evallog_mat(points);
	vec2mxArray(v, output[0]);
}
#endif
