/*!
\file
\brief wrapper function for BM.epredictor()


 */

#include <stat/emix.h>

using namespace bdm;

#ifdef MEX
#include <estim/arx_ext.h>
#include <estim/kalman.h>
#include <estim/particles.h>
#include <estim/mixtures.h>
#include <mex/mex_BM.h>

void mexFunction ( int n_output, mxArray *output[], int n_input, const mxArray *input[] ) {
	// Check the number of inputs and output arguments
	if ( n_input<1 ) mexErrMsgTxt ( 
		"Usage:\n"
		"[pred_struct]=bm_epredictor(BM_struct, cond)\n"
		"  BM_struct = struct('class','BM_offspring',...);      % description of Bayesian Model (BM)\n"
		"  cond = [...];                                        % vector of conditioning variables (if needed)\n"
		"output:\n"
		"  pred_struct  = struct('class','epdf_offsprin',...);  % description of predictor f(yt|data).\n"
		);

	RV::clear_all();
	//CONFIG
	
	UImxArray Cfg(input[0]);
	Cfg.writeFile("BM_predictor.cfg");

	shared_ptr<BM> bm=UI::build<BM>(Cfg);
	
	if (bm){	
		vec cond;
		if (n_input>1){
			cond =mxArray2vec(input[1]);
		}
		//if ( n_output<1 ) mexErrMsgTxt ( "No output - nothing to do!" );
		shared_ptr<epdf> ep=bm->epredictor(cond);
		UImxArray Out;
		UI::save(ep.get(), Out);
		output[0]=UImxArray::create_mxArray(Out);
	} else { 
		mexErrMsgTxt ( "Given object is not BM" );
	}
}
#endif
