%> @file mexMerger.m
%> @brief File mapping root class of Mergerbase from BDM
% ======================================================================
%> @brief Abstract class of Bayesian Model (estimator), bdm::BM
%
%> This class provides a bridge between bdm::MergerBase and Matlab
% ======================================================================
classdef mexGaussMergerArit < mexMerger
    methods
        %> check consistency of the object and fill defaults
        function obj=validate(obj)
            if length(obj.sources)<1
                error('No sources to merge');
            end
            
            obj.merger= struct('class','egauss');
        end
        
        
        %> Merge sources into the merger 
        function obj=merge(obj)
            Cov = epdf_covariance(obj.sources{1});
            mea = epdf_mean(obj.sources{1});
            
            Mom1 = obj.weights(1)*mea;
            Mom2 = obj.weights(1)*(Cov+mea*mea');
            for i=2:length(obj.sources)
                Cov = epdf_covariance(obj.sources{i});
                mea = epdf_mean(obj.sources{i});
                
                Mom1 = Mom1+ obj.weights(i)*mea;
                Mom2 = Mom2 + obj.weights(i)*(Cov+mea*mea');
            end
            obj.merger.mu = Mom1;
            obj.merger.R = Mom2 - Mom1*Mom1';
            % transform old estimate into new estimate
        end
    end
end