%> @file mexMerger.m
%> @brief File mapping root class of Mergerbase from BDM
% ======================================================================
%> @brief Abstract class of Bayesian Model (estimator), bdm::BM
%
%> This class provides a bridge between bdm::MergerBase and Matlab
% ======================================================================
classdef mexMerger
    properties
        %> weights of the merged densities
        weights
        %> source pdfs to be merged
	    sources
        %> merged density - offspring of mexEpdf!
        merger
        %
    end

    methods
        %> check consistency of the object and fill defaults
        function obj=validate(obj)
            % e.g. check if all sources are compatible
        end
        %> Merge sources into the merger 
        function obj=merge(obj)
            % transform old estimate into new estimate
        end
        
        %%%%%     TECHNICAL ISSUES %%%%%%%
        function src = get_sources(obj)
           src = obj.sources;
        end
        function obj = set_sources(obj,src)
           obj.sources = src;
        end
        function m = get_merger(obj)
           m = obj.merger;
        end
        function obj = set_merger(obj,m)
           obj.merger=m;
        end
    end
end