%> @file mexMerger.m
%> @brief File mapping root class of Mergerbase from BDM
% ======================================================================
%> @brief Abstract class of Bayesian Model (estimator), bdm::BM
%> 
%> The purpose of this class is to combine information from the source pdfs:
%>  sources = {f1,f2,f3}
%> into a single pdf called the merger.
%> 
%> Since this is an abstract class, the class does not define what is the type of the merger.
%> Offsprings of this class can generate an arbitrary pdf, which is returned by function merger.
%> The only requirement of the result is that it must be a valid pdf, i.e. it must pass through generic epdf_* functions.
%>
%> This class provides a bridge between bdm::MergerBase and Matlab
% ======================================================================
classdef mexMerger
    properties
        %> weights of the merged densities
        weights
        %> source pdfs to be merged
	    sources
        %> merged density - offspring of mexEpdf!
        merger
        %
    end

    methods
        %> check consistency of the object and fill defaults
        function obj=validate(obj)
            % e.g. check if all sources are compatible
        end
        %> Merge sources into the merger 
        function obj=merge(obj)
            % transform old estimate into new estimate
        end
        
        %%%%%     TECHNICAL ISSUES %%%%%%%
        function src = get_sources(obj)
           src = obj.sources;
        end
        function obj = set_sources(obj,src)
           obj.sources = src;
        end
        function m = get_merger(obj)
           m = obj.merger;
        end
        function obj = set_merger(obj,m)
           obj.merger=m;
        end
    end
end