classdef mexMultiNom < mexEpdf
    properties
      % from wikipedia
    	p      % vector of probabilities
    end
    methods
        function m=mean(obj)
            m = obj.p;
        end
        
        function obj=validate(obj)
            if length(obj.p)<1
                error('empty p');
            end
            sump = sum(obj.p);
            if sump~=1
                error('non-normalized p')
                obj.p=obj.p/sump;
            end
        end

        function dim=dimension(obj)
            dim = 1;
        end

        function v=variance(obj)
            v=obj.p.*(1-obj.p);
        end

        function l=evallog(obj,x)
            l=log(obj.p(x));
        end

        function s=sample(obj)
            csum=cumsum(obj.p);%sample_exponential(0,1);
            u = rand;
            s=1;
            while (csum(s)<u)
                s=s+1;
            end
        end
    end
end