clear all
% load data created by the MpdfDS_example
load pdfds_results

DS.class   = 'MemDS';
DS.Data    = Data;
DS.drv     = drv;

%%%%%% ARX estimator conditioned on frg

A1.class = 'ARXfrg';
A1.yrv = y;
A1.rv = RV({'theta','r'},[3,1]);
A1.rgr = RVtimes([y,u],[-3,-1]) ; 
A1.log_level = 'logbounds';
A1.frg = 0.98;
% A1.prior.class='egiw';
% A1.prior.dimx=1;
% A1.prior.nu=10;
% A1.prior.V=diag([1,0.01,0.01,0.01]);
A1.name = 'A1';


%%%%%% Random walk on frg - Dirichlet 
phi_pdf.class = 'mDirich';         % random walk on coefficient phi
phi_pdf.rv    = RV({'phi','1_phi'});       % 2D random walk - frg is the first element
phi_pdf.k     = 0.001;              % width of the random walk
phi_pdf.betac = [0.1 0.1];         % stabilizing elememnt of random walk

%%%%%% Particle
p.class = 'MarginalizedParticle';
p.parameter_pdf = phi_pdf;         % Random walk is the parameter evolution model
p.bm    = A1;

% prior on ARX
%%%%%% Combining estimators in Marginalized particle filter
E.class = 'PF';
E.particle = p;                    % ARX is the analytical part
E.res_threshold = 0.7;             % resampling parameter
E.n = 10;                           % number of particles
E.prior.class = 'eDirich';         % prior on non-linear part
E.prior.beta  = [10 1]; % 
E.log_level = 'logbounds,logweights,logmeans,logvars';
E.name = 'MPF';

A2=A1;
A2.class='ARX';
A2.frg=1.0;
A2.name = 'MPFf';

[M,Str]=estimator(DS,{E,A2});

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plot results
ndat = size(M.DS_dt_u,1);

figure(1);
subplot(2,2,1);
plotestimates(true_theta, M.MPF_apost_mean_theta, M.MPF_apost_lbound_theta, M.MPF_apost_ubound_theta);
title(' Regression parameters \theta')
set(gca,'YLim',[-1.5,1]);

subplot(2,2,2);
plotestimates(true_R, M.MPF_apost_mean_r,M.MPF_apost_lbound_r,M.MPF_apost_ubound_r);
title('Variance parameters r')

subplot(2,2,3);
plotestimates(1, M.MPF_apost_mean_phi(:,1),M.MPF_apost_lbound_phi(:,1),M.MPF_apost_ubound_phi(:,1));
title('Forgetting factor')


