#include "ctrlbase.h"

namespace bdm {

  //! Universal LQG controller
class LQG_universal : public Controller{
public:
    //! loss function
    Array<quadraticfn> Losses;
    //! model of evolutin
    Array<linfn> Models;

  protected:
    //! control law: u_t = L [rvc, 1]
    mat L;
    
    //! Matrix pre_qr
    mat pre_qr;
    
    //! Matrix post_qr
    mat post_qr;
    
public:
    //! function redesigning the control strategy
    virtual void redesign() {};
    //! returns designed control action
    virtual vec ctrlaction ( const vec &cond ) const {
        return L*concat(cond,1.0);
    }

    void from_setting ( const Setting &set ) {
      UI::get(Losses, set, "losses",UI::compulsory);
      UI::get(Models, set, "models",UI::compulsory);
    }
    //! access function
    const RV& _rv() {
        return rv;
    }
    //! access function
    const RV& _rvc() {
        return rvc;
    }
    //! register this controller with given datasource under name "name"
    virtual void log_register ( logger &L, const string &prefix ) { }
    //! write requested values into the logger
    virtual void log_write ( ) const { }

};


} // namespace
