classdef mexLaplaceBM < mexBM
    % Approximate Bayesian estimator of parameters of Laplace distributed observation.
    % Maximum likelihood approximation of the Bayes rule is used, posterior is in the form of dirac.
    properties
        max_window_length = 10;                               % max window length (default = 10)
        data_window =[];                                      % sliding window of data 
    end
    methods
        function obj=validate(obj)                            % prepare all internal objects for use
            obj.apost_pdf = mexDirac;
            obj.apost_pdf.point = [0;0];
            obj.log_evidence = 0;                             % evidence is not computed!
        end

        function dims=dimensions(obj)
            %please fill: dims = [size_of_posterior size_of_data size_of_condition]
            dims = [2,1,0]                                    % we have: [2d parameters, 1d observations, 0d condition]
        end
        function obj=bayes(obj,dt,cond)                       % approximate bayes rule
            if size(obj.data_window,2)>=obj.max_window_length
                obj.data_window = [dt obj.data_window(1:end-1)];
            else
                obj.data_window = [dt obj.data_window];
            end
            % transform old estimate into new estimate
            m_hat = mean(obj.data_window);
            b_hat = sum(abs(obj.data_window-m_hat))/ size(obj.data_window,2);
            obj.apost_pdf.point = [m_hat; b_hat];             % store result in psoterior pdf
        end
        function p=epredictor(obj,cond)                       % when predictive density is needed approximate it by Laplace with point estimates
            % return predictive density (max likelihood)
            p = mexLaplace;
            p.mu = obj.apost_pdf.point(1);
            p.b  = obj.apost_pdf.point(2);
				% do not forget to validate
            p=p.validate;
				% assign descriptions
				p.rv = yrv;
				% rvc is empty be default
        end
    end

end