/*!
  \file
  \brief Robust Bayesian auto-regression model
  \author Jan Sindelar.
*/

#ifndef ROBUST_H
#define ROBUST_H

#include <stat/exp_family.h>
#include <limits>
	
using namespace bdm;
using namespace std;

#include <vector>

public const max_range = numeric_limits<double>::max( )/10e-5.0;

class polyhedron;
class vertex;

class polyhedron
{
	vector<&polyhedron> parents;

	vector<&polyhedron> children;

	vector<&vertex> vertices;

	vector<&polyhedron> positivechildren;

	vector<&polyhedron> negativechildren;

	vector<&polyhedron> neutralchildren;

	vector<vector<&vertex>> triangulations;

	int multiplicity = 1;	

public:

	vector<int> kids_rel_addresses;

	polyhedron()
	{
		parents  = new vector<&polyhedron>();
		children = new vector<&polyhedron>();
		vertices = new vector<&vertex>();
		
		positivechildren = new vector(&polyhedron)();
		negativechildren = new vector(&polyhedron)();
		neutralchildren  = new vector(&polyhedron)();

		triangulations = new vector<vector<&vertex>>();

		kids_rel_addresses = new vector<int>();
	
	}
	

	void RaiseMultiplicity()
	{
		multiplicity++;
	}

	void LowerMultiplicity()
	{
		multiplicity--;
	}
	
	
};

class vertex : polyhedron
{
	vector<double> coordinates;

public:

	vertex();

	vertex(vector<double> coordinates)
	{
		this.coordinates = coordinates;
	}

	void push_coordinate(double coordinate)
	{
		coordinates.push_back(coordinate);
	}

	vector<double> get_coordinates()
	{
		return this.coordinates();
	}
}

class toprow : polyhedron
{
	vector<double> condition;

public:

	toprow();

	toprow(double condition)
	{
		this.condition = condition;
	}

}




//! Conditional(e) Multicriteria-Laplace-Inverse-Gamma distribution density
class emlig : public eEF{

	vector<vector<&polyhedron>> statistic;
	
public:	

	emlig(int number_of_parameters)
	{
		create_statistic(int number_of_parameters);
	}

	emlig(vector<vector<&polyhedron>> statistic)
	{
		this.statistic = statistic;
	}



protected:

	create_statistic(int number_of parameters)
	{
		vector<double> origin_coord = new vector<double>();	

		origin = new vertex(origin_coord);

		origin.vertices.push_back(origin);

		vector<&polyhedron> origin_vec = new vector(&polyhedron)(1,);

		statistic.push_back(origin_vec);

		for(int i=0;i++;i<number_of_parameters)
		{
			vertex new_point1 = new vertex(origin.get_coordinates().push_back(max_range));
			vertex new_point2 = new vertex(origin.get_coordinates().push_back(-max_range));	

			vector(vector(&polyhedron)) new_statistic1 = new vector(vector(&polyhedron));
			vector(vector(&polyhedron)) new_statistic2 = new vector(vector(&polyhedron));

			
			for(int j=0;j++;j<statistic.size())
			{
				vector<&polyhedron>::iterator horiz_ref = statistic[j].begin();

				int element_number = 0;

				do
				{	
					if(!horiz_ref.parents.empty())
					{
						vector<&polyhedron>::iterator end_ref = horiz_ref.parents.end();

						vector<&polyhedron>::iterator parent_ref = horiz_ref.parents.begin();

						do
						{
							parent_ref.kids_rel_addresses.push_back(element_number);

							parent_ref++;
						}
						while(parent_ref!=end_ref)
					}

					toprow current_copy1 = new toprow(new vector<int>(i+2,0));
					toprow current_copy2 = new toprow(new vector<int>(i+2,0));

					vector<&vertex>::iterator vert_ref = horiz_ref.vertices.begin();

					do
					{
						current_copy1.vertices.push_back(vert_ref);
						current_copy2.vertices.push_back(vert_ref);

						vert_ref++;
					}
					while(!vert_ref!=horiz_ref.vertices.end())

					current_copy1.vertices.push_back(new_point1);
					current_copy2.vertices.push_back(new_point2);

					current_copy1.triangulations.push_back(current_copy1.vertices);
					current_copy2.triangulations.push_back(current_copy2.vertices);

					vector<int>::iterator kid_ref = horiz_ref.kids_rel_addresses.begin();

					if(!horiz_ref.kids_rel_addresses.empty())
					{
						do
						{						
							current_copy1.children.push_back(new_statistic1[i,kid_ref]);
							current_copy2.children.push_back(new_statistic2[i,kid_ref]);

							new_statistic1[i,kid_ref].parents.push_back(current_copy1);
							new_statistic2[i,kid_ref].parents.push_back(current_copy2);

							kid_ref++;

						}
						while(kid_ref!=horiz_ref.kids_rel_addresses.end())

						horiz_ref.kids_rel_addresses.clear();
					}
					else
					{
						current_copy1.children.push_back(new_point1);
						current_copy2.childern.push_back(new_point2);

						new_point1.parents.push_back(current_copy1);
						new_point2.parents.push_back(current_copy2);
					}

					current_copy1.children.push_back(horiz_ref);
					current_copy2.children.push_back(horiz_ref);

					new_statistic1[i+1].push_back(current_copy1);
					new_statistic2[i+1].push_back(current_copy2);
					
					element_number++;
				}
				while(statistic[j].end() != horiz_ptr++)
			}				
			
		}
	}


	
	
};

//! Robust Bayesian AR model for Multicriteria-Laplace-Inverse-Gamma density
class RARX : public BMEF{
};


#endif //TRAGE_H
