/*!
\file
\brief check how the structure is processed


 */

#include <stat/emix.h>
#include <estim/particles.h>
#include <estim/kalman.h>
#include <mpdm/arx_agent.h>


using namespace bdm;

#ifdef MEX
#include <mex/mex_parser.h>
#include <mex/mex_function.h>
#include <mex/mex_BM.h>

void mexFunction ( int n_output, mxArray *output[], int n_input, const mxArray *input[] ) {
	// Check the number of inputs and output arguments
	if ( n_input<1 ) mexErrMsgTxt ( "Usage:\n"
		                                "instance=class_defaults(struct)\n"
		                                "  struct              % configuration structure of a class\n"
		                                "output:\n"
		                                "  the same structure filled with the defaults.\n\n"
		                                "This operation is usefull for obtaining info about class defaults, or success of passing info to it" );

	RV::clear_all();
	//CONFIG
	UImxArray Cfg(input[0]);
	Cfg.writeFile("class_defaults.cfg");
	if ( n_output<1 ) mexErrMsgTxt ( "No output - nothing to do!" );
	
#else
	int main ( int argc, char* argv[] ) {
		const char *fname;
		if ( argc>1 ) {
			fname = argv[1];
		} else {
			fname="class_defaults.cfg";
		}
		UIFile Cfg ( fname );
#endif
		
	shared_ptr<root> r=UI::build<root>(Cfg);

#ifdef MEX
	UImxArray Ret;
	UI::save(r.get(), Ret);

	Ret.writeFile("cls_dflt.cfg");
	output[0] = Ret.create_mxArray();
#else
	UIFile Out;
	UI::save(r.get(),Out);
	Out.writeFile("defaults");
#endif
}
