function h=epdf_1dplot(pdf,xlims, points)
% function evaluates given pdf on support
%  xlims = [x_begin, x_end] --or-- empty
%  points = if not given, 100

if nargin<3
    points = 100;
end

if nargin<2 | isempty(xlims)
    p_mean = epdf_mean(pdf);
    p_var  = epdf_variance(pdf);
    xlims = p_mean(1)*[1 1] + [-3 3]*sqrt(p_var(1));
end

steps = [xlims(2)-xlims(1)];
x = xlims(1):steps/(points-1):xlims(2);
v = epdf_evallog_mat(pdf,x);
h=plot(x,exp(v));