/*!
  \file
  \brief Bayesian Filtering for linear Gaussian models (Kalman Filter) and extensions
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef EKF_TEMP_H
#define EKF_TEMP_H

#include "libKF.h"

using namespace itpp;

//!Extended Kalman filter with unknown \c Q and \c R
class EKFful_unQR : public EKFfull , public BMcond {
public:
	//! Default constructor
	EKFful_unQR ( RV rx, RV ry,RV ru,RV rQR ) :EKFfull ( rx,ry,ru ),BMcond ( rQR ) {};
	void condition ( const vec &QR0 ) {
		Q=diag(QR0(0,dimx-1));
		R=diag(QR0(dimx,dimx+dimy-1));
	};
};


#endif EKF_TEMP_H
