/************************************
        Extended Kalman Filter
        Matrix operations

        V. Smidl

Rev. 30.8.2010

30.8.2010      Prvni verze

*************************************/
/* Matrix multiply Full matrix by upper diagonal matrix; */
extern void mmultAU(int *m1, int *up, int *result, unsigned int rows, unsigned int columns);

/* perform Thorton update of UD matrix using PSI*U, Q, and temporaries G, Dold, for size dimx*/
extern void thorton(int *U, int *D, int *PSIU, int *Q, int *G, int *Dold, unsigned int dimx);

/* perform Bierman update of UD matrix using difz, R and xp, for size dimx*/
extern void bierman(int *difz, int *xp, int *U, int *D, int *R, unsigned int dimy, unsigned int dimx );

/* perform Thorton update of UD matrix using PSI*U, Q, and temporaries G, Dold, for size dimx*/
extern void thorton_fast(int *U, int *D, int *PSIU, int *Q, int *G, int *Dold, unsigned int dimx);

/* perform Bierman update of UD matrix using difz, R and xp, for size dimx*/
extern void bierman_fast(int *difz, int *xp, int *U, int *D, int *R, unsigned int dimy, unsigned int dimx );