%> @file mexLaplace.m
%> @brief Matlab implementation of Gaussian density
% ======================================================================
%> @brief Unconditional Gaussian density
%
%> \f[ f(x|\mu,b) \propto \exp(-(x-\mu)'R^{-1}(x-\mu))\f]
% ======================================================================
classdef mexGauss < mexEpdf
    properties
    	mu % mean values
    	R  % variance
    end
    methods
        function m=mean(obj)
            m = obj.mu;
        end
        function obj=validate(obj)
            if size(obj.R,1)~=size(obj.R,2)
                error('matrix R is not square');
            end
            if length(obj.mu)~=size(obj.R,1)
                error('incompatible mu and R');
            end
        end
        function dim=dimension(obj)
            dim = size(obj.mu,1);
        end
        function v=variance(obj)
            v=diag(R);
        end
        function l=evallog(obj,x)
            l=-log(2*obj.b)-abs(x-obj.mu)/obj.b;
        end
        function s=sample(obj)
            z = randn(obj.dimension);
            s = obj.mu+chol(R)'*z;
        end
    end
end