#!/bin/sh

CLASS=$1

cat ../../../../library/doc/html/hierarchy.html \
| html2text -nobs \
| tail -n +13 \
| head -n -2 \
| sed 's/^\( *\). /\1  /' \
| sed 's/      / /g' \
>tmp__hierarchy

cat tmp__hierarchy \
| ./class_hierarchy.pl --class=$CLASS \
| sed 's/ *\(.*\)/\1/' \
> tmp__classes

cat tmp__classes | ./classnames2files.pl | xargs tidy -modify -asxhtml 2>/dev/null

cat tmp__classes | while read line
    do ./filter_html.pl --class=$line
done

cat tmp__classes | xargs ./filter_annotated.pl

CLS_DEF=`echo $CLASS | sed "s/::/_/g"`
cp ../html/bdm_doc/annotated.html ../html/bdm_doc/annotated_$CLS_DEF.html
