#include "bdmerror.h"
#include <iostream>
#include <iomanip>
#include <stdexcept>

namespace bdm {

void bdm_assert_f ( const std::string &ass, const std::string &msg, const std::string &file, int line ) {
    std::ostringstream error;
    error << "*** Assertion failed in " << file << " on line " << line
          << ":\n" << msg << " (" << ass << ")\n";
    throw std::runtime_error ( error.str() );
}

void bdm_error_f ( const std::string &msg, const std::string &file, int line ) {
    std::ostringstream error;
    error << "*** Error in " << file << " on line " << line << ":\n"
          << msg << "\n";
    throw std::runtime_error ( error.str() );
}

void bdm_warning_f ( const std::string &msg, const std::string &file, int line ) {
    std::cerr << "*** Warning in " << file << " on line " << line << ":\n"
              << msg << std::endl;
}

}
