function [m n losses]=mc_study(system,apriori,n)
p=0;
[H C]=load_H;  
losses=zeros(3,n);

for i=1:n
    system.b=apriori.b0 + sqrt(apriori.P0)*randn;
    while (system.b==0)
        system.b=apriori.b0 + sqrt(apriori.P0)*randn;
    end
    seed=randn(1,system.horizont);
    
    losses(1,i)=cc(system,apriori,seed);
    losses(2,i)=rizeni(H,C,system,apriori,seed);
    losses(3,i)=alstr(system,apriori,seed);
    
end
%losses=min(losses,10);
m=mean(losses,2);
n=median(losses,2);
if p==1
    losses=losses/m(3);
    m=mean(losses,2);
    n=median(losses,2);
    a=2;
    figure
    for i=1:size(losses,1)
        subplot(3,1,i)
        losses(i,:)=min(losses(i,:),a);
        hist(losses(i,:),100); hold on
        AXIS([0 a 0 80]); 
        plot(0*(1:80)+m(i), 1:80,'r')
        plot(0*(1:80)+n(i), 1:80,'g')
        switch(i)
            case(1)
                text(0.1,60,'\fontsize{18} CC')
                ylabel('\fontsize{18} etnost');
            case(2)
                text(0.1,60,'\fontsize{18} SIDPS')
            case(3)
                text(0.1,60,'\fontsize{18} DP')
        end
        
    end
    xlabel('\fontsize{18} relativn ztrta');
    y_0=num2str(apriori.y0);    b_0=num2str(apriori.b0);    P_0=num2str(apriori.P0);
    %text(1.8,250,['\fontsize{18}P_0 = ',P_0]);
    text(1.8,265,['{}_{^{\fontsize{18}\theta}}^{\fontsize{20}\^}_{\fontsize{14}0} \fontsize{18} = ',b_0]);
    %text(1.8,278,['\fontsize{18}y_0  = ',y_0]);
    set( get(gcf, 'Children'), 'FontSize', 18);
end


end