function [ztrata u y b P]=cc(system,apriori,seed)

horizont=system.horizont;

y=zeros(1,horizont);
b=zeros(1,horizont);
P=zeros(1,horizont);
u=zeros(1,horizont-1);
ztrata=0;

y(1)=apriori.y0;
b(1)=apriori.b0;
P(1)=apriori.P0;

for i=1:horizont
    u(i)=-y(i)*b(i)/(b(i)^2+P(i));
    
    y(i+1)=y(i)+system.b*u(i)+system.sigma*seed(i);
    K=u(i)*P(i)/(P(i)*u(i)^2+system.sigma^2);
    b(i+1)=b(i)+K*(y(i+1)-y(i)-b(i)*u(i));
    P(i+1)=(1-K*u(i))*P(i);   

    ztrata=ztrata+y(i+1)^2;
end

end

