# This Module Sets CMake variables for BDM
# Variable BDM_SOURCE_DIR must be set
#
# Other respected variables are
# ITPP_DIR, ACML_DIR, MATLAB_ROOT
#

IF(NOT BDM_SOURCE_DIR)
      MESSAGE(FATAL_ERROR "BDM_SOURCE_DIR is not set!")
ENDIF(NOT BDM_SOURCE_DIR)

######################
#Platform specific
IF(WIN32)
# IF YOU WANT TO USE YOUR OWN INSTALLATION OF THE NEXT EXTERNAL LIBRARIES,
# THEN IT IS NECESSARY TO CREATE TEXT FILE "\system\WIN32\LOCAL_PATHS.TXT" WITH 
# COPIES OF THE TWO FOLLOWING LINES AND THEN CORECT ALL THE INVOLVED PATHS
	IF(NOT ACML_DIR)
		SET(ACML_DIR "${BDM_SOURCE_DIR}\\system\\win32\\acml3.6.0")
	ENDIF(NOT ACML_DIR)
	
	INCLUDE(\\system\\win32\\local_paths.txt OPTIONAL)	
	ADD_DEFINITIONS(-DHAVE_ACML)
	ADD_DEFINITIONS(/wd4290)
	ADD_DEFINITIONS(-D_CRT_SECURE_NO_DEPRECATE -D_CRT_NONSTDC_NO_DEPRECATE -D_HAS_CPP0X=0)
	ADD_DEFINITIONS(-DLIBCONFIG_STATIC -DLIBCONFIGXX_STATIC)

	FIND_PACKAGE(ACML REQUIRED)
	IF(ACML_FOUND)
		INCLUDE_DIRECTORIES(${ACML_INCLUDE_DIR})
		LINK_DIRECTORIES(${NATIVE_ACML_LIB_PATH})
	ENDIF(ACML_FOUND)
	SET(lapack_libs libacml_dll)
ENDIF(WIN32)
IF(APPLE)
	FIND_LIBRARY(FRAMEWORK_VECLIB vecLib)
	ADD_DEFINITIONS(-DHAVE_XLOCALE_H)
	SET(lapack_libs ${FRAMEWORK_VECLIB})
ENDIF(APPLE)
IF(UNIX)
	SET(lapack_libs lapack blas)
ENDIF(UNIX)

# Local ettings should be written to file called CMakeLists.local
# Use this option for machine-specific options, such as prallel architectures
INCLUDE(CMakeLists.local OPTIONAL)	

FIND_PACKAGE(Matlab COMPONENTS)


## BUILD own ITPP
INCLUDE_DIRECTORIES("${BDM_SOURCE_DIR}/bdm/base")#${ITPP_INCLUDE_DIR})
LINK_DIRECTORIES("${BDM_SOURCE_DIR}/bdm/base/itpp")#${NATIVE_ITPP_LIB_PATH})


IF(UNIX)
	SET(CMAKE_BUILD_TYPE Debug)
	IF(MATLAB_FOUND)
		SET(CMAKE_CXX_FLAGS "-Wall -pipe  -Wno-unknown-pragmas -fPIC")
		SET(CMAKE_C_FLAGS "-Wall -pipe  -Wno-unknown-pragmas -fPIC")
	ELSE(MATLAB_FOUND)
		SET(CMAKE_CXX_FLAGS "-Wall -Wno-unknown-pragmas ")
		SET(CMAKE_C_FLAGS "-Wall -Wno-unknown-pragmas ")
	ENDIF(MATLAB_FOUND)
	
	SET(CMAKE_CXX_FLAGS_RELEASE " -DNDEBUG -O2")
	SET(CMAKE_CXX_FLAGS_DEBUG "-g -O0")
ENDIF(UNIX)

##
## PREPARE MACROS for building executables
##

MACRO(EXEC FN)
	add_executable (${FN} ${FN}.cpp)
	target_link_libraries (${FN} bdm)
	target_link_libraries (${FN} itpp)
	target_link_libraries (${FN} ${lapack_libs})
	target_link_libraries (${FN} ${ARGN}) ## Additional libraries can be added to a macro
ENDMACRO(EXEC)

MACRO(LINK_EXEC FN)
	target_link_libraries (${FN} bdm)
	target_link_libraries (${FN} itpp)
	target_link_libraries (${FN} ${lapack_libs})
ENDMACRO(LINK_EXEC)
	
MACRO(MEX FN)
	IF(MATLAB_FOUND)
		INCLUDE_DIRECTORIES(${MATLAB_INCLUDE_DIR} "${BDM_SOURCE_DIR}/bdm")
		LINK_DIRECTORIES("${BDM_SOURCE_DIR}/bdm")
		IF(APPLE)
		    LINK_DIRECTORIES("/Applications/MATLAB_R2007b/bin/maci/")
		ENDIF(APPLE)
		IF(WIN32)
			ADD_LIBRARY("${FN}.${MATLAB_MEX_SUFFIX}" MODULE ${FN}.cpp "${BDM_SOURCE_DIR}/system/mexFunction.def")
		ELSE(WIN32)
			ADD_LIBRARY("${FN}.${MATLAB_MEX_SUFFIX}" MODULE ${FN}.cpp)
		ENDIF(WIN32)

		set_target_properties("${FN}.${MATLAB_MEX_SUFFIX}" PROPERTIES
			PREFIX ""
			SUFFIX "" 
			COMPILE_FLAGS "-DMEX"
		)
		# general libraries
		TARGET_LINK_LIBRARIES("${FN}.${MATLAB_MEX_SUFFIX}" ${MATLAB_LIBRARIES} bdm itpp ${lapack_libs})
		## Additional libraries can be added to a macro
		target_link_libraries ("${FN}.${MATLAB_MEX_SUFFIX}" ${ARGN}) 
	ENDIF(MATLAB_FOUND)
ENDMACRO(MEX)
