function Sim = facarxls(ychn, str, default)
% build ARX LS factor
% Fac = facarxls(ychn, str,default)
% Fac = facarxls(ychn, str) default = 'A'
%    
% Fac     : ARX LS factor    type = 2
% ychn    : output channel
% str     : factor structure
% default : string determining type of default values to be used, see defaults.m
%
% Design  : P. Nedoma
% Updated : 9.3.00
% Project : ProDaCTools
% See also: facarx, comarx, comarxls, defaults
%
% Reference:
% Updated  : June 02, MK

%%%%%%%% begin patch MK
% test of arguments
  if nargin<2
     error(' use: Fac = facarxls(ychn, str, default) ');
  end
  if ~isempty(str)
     if size(str,1)~=2
        error('invalid structure: two rows are expected');
     end
     if any( str(:)<0)
        error('invalid structure: time delays must be non-negative');
     end
  end
  if ychn<1
     error('invalid output channel: it has to be natural number');
  end
% test end
%%%%%%%%  end of patch MK
   if nargin<3, default = 'A'; end
   [dia,cove,dfm]=defaults(default); % defaults
   npsi  = size(str,2);              % length of regression vector
   Eth  = zeros(1,npsi);             % LS parameter estimates
   Cth  = eye(npsi,npsi)*dia;        % "covariance" of Eth

   Sim = struct('ychn',ychn,'str',str,'dfm', dfm, 'type', 2, ...
            'cove',cove, 'Eth',Eth,'Cth',Cth);
