/*!
  \file
  \brief DataSource for experiments with Aimsun
  \author Jan Prikryl.

*/

/* WIN32 stuff */
#include <windows.h>
#include <stdio.h>
#include <tchar.h>

#include <base/loggers.h>

extern "C" {
  #include "eh_hrd.h"
  #include "vgs_hrd.h"
}

using namespace bdm;

//! Simulator of traffic - AIMSUN
class AimsunDS : public DS
{

protected:
	//! Pointer to realised signal plans stored in local data space of eh_api.
	eh_els3hrd * p_rsp;

	//! Target buffer when querying VGS for last section statistics data.
	vgs_sections_stats sections_stats;

public:
    //! Constructor with fixed sampling period
    AimsunDS ();

	//! Destructor
	~AimsunDS ();

    //! Get measurements and signal plans from ELS3 controllers
    void getdata ( vec &dt ) const;

    //! Write new signal plans to ELS3
    void write ( vec &ut );

    //! Wait for new data and copy them out to local buffers
    void step();
	
	//! number of steps
	int max_length() {return stopCycle;}

	//! converts i to string, if i has only one digit, adds 0 before it
	string int_to_string(int const i);

	virtual void from_setting ( const Setting &cfg );
	virtual void validate ( void );
	
    // TODO dodelat void to_setting( Setting &root ) const;
private:
	//! Handle of the Aimsun process. Used to terminate Aimsun after simulation.
	intptr_t hPid;
	
	//! File name containing vehicle entrances into the network
	string entranceFileName;
	
	//! Stop time of the simulation
	string stopTime;

	//! Number of cycles of the simulation
	int stopCycle;
	
	void AimsunDS::initVGS (
		const vgs_headway_mode headway,
		const string &entrancePath,
		const string &sectionStatsPath,
		const string &globalStatsPath
	);

};
UIREGISTER(AimsunDS);