//
// C++ Implementation: itpp_ext
//
// Description:
//
//
// Author: smidl <smidl@utia.cas.cz>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "userinfo.h"

GlobalXercesConnector::GlobalXercesConnector()
{
	// initialize the XML library
	XMLPlatformUtils::Initialize();

	// get a serializer, an instance of DOMWriter (the "LS" stands for load-save).
	pImplementation = DOMImplementationRegistry::getDOMImplementation( XMLString::transcode( "LS" ));

	pSerializer = ( (DOMImplementationLS*)pImplementation )->createDOMWriter();
	// set user specified end of line sequence and output encoding
	pSerializer->setNewLine( XMLString::transcode( "\n" ) );
	// optionally, set the format-pretty-print feature
	if (pSerializer->canSetFeature(XMLUni::fgDOMWRTFormatPrettyPrint, true))
		pSerializer->setFeature(XMLUni::fgDOMWRTFormatPrettyPrint, true);

	pParser = new XercesDOMParser;	
	pParser->setValidationScheme(XercesDOMParser::Val_Auto);
	pParser->setDoNamespaces(false);
	pParser->setDoSchema(false);
}

GlobalXercesConnector::~GlobalXercesConnector()
{
	delete pParser; 
	delete pSerializer;

	// terminate the XML library
	XMLPlatformUtils::Terminate();
}

string GlobalXercesConnector::XMLCh2str( const XMLCh* const  XMLCh_str )
{
	char *local = XMLString::transcode( XMLCh_str );
	string res = local;		
	XMLString::release( &local );
	return res;
}

bool GlobalXercesConnector::Comparator::operator()( const XMLCh* const a , const XMLCh* const b) const
{
	return ( XMLString::compareString(a,b) > 0);
}	

const GlobalXercesConnector XMLConnector;

//////////////////////

Attribute::Attribute( const string name ) 
	: 	transcodedName ( XMLString::transcode( name.c_str() ) ) 
{	
	XMLString::lowerCase( transcodedName );
}

Attribute::~Attribute() 
{		 
	XMLString::release( (XMLCh**)&transcodedName );
}

void Attribute::Attach( MappedAttributes &externalAttributes)
{
	pair<const XMLCh* const, Attribute* const> newPair( transcodedName, this );
	externalAttributes.insert(newPair);
}

void Attribute::FillAttribute(DOMElement &element)
{
	DOMDocument* pDoc = element.getOwnerDocument();
	DOMAttr* pAttribute = pDoc->createAttribute( transcodedName );

	const string attributeValue = Get();
	XMLCh* transcodedValue = XMLString::transcode( attributeValue.c_str() ); 
	pAttribute->setValue( transcodedValue );
	XMLString::release( &transcodedValue );

	element.setAttributeNode(pAttribute);			
}

DoubleAttribute::DoubleAttribute( const string name) 
	: Attribute( name )
{
	value = 0;
}

void DoubleAttribute::Set( const string str )
{
	value = atof( str.c_str() );
}

const string DoubleAttribute::Get()
{ 
	char buffer[50];
	sprintf( buffer, "%f", value );
	return string( buffer );
}   


/*!
@brief User Info base class

This class is used to store information about parameters of an object. It support loading and saving of the information and, potentially, interaction with the user.
*/
IntAttribute::IntAttribute( const string name ) 
	: Attribute( name )
{
	value = 0;
}

void IntAttribute::Set( const string str )
{
	value = atoi( str.c_str() );
}

const string IntAttribute::Get()
{ 
	char buffer[50];
	sprintf( buffer, "%d", value );
	return string( buffer );
}   


/*!
@brief User Info base class

This class is used to store information about parameters of an object. It support loading and saving of the information and, potentially, interaction with the user.
*/
StringAttribute::StringAttribute( const string name ) 
	: Attribute( name ),
	value("")
{
}

void StringAttribute::Set( const string str )
{
	value = str.c_str();
}

const string StringAttribute::Get()
{ 
	return value;		
}   


