#include "userinfo.h"

class Engine 
{
public:
	string producer;
	double consumption;

	Engine( string producer, double consumption )
		: producer( producer ),
		consumption( consumption )
	{
	}
};

//! User info for strings
class EngineUI : public UserInfo<Engine> 
{
public:
	StringAttribute producer;
	DoubleAttribute consumption;
	
	EngineUI()
		: UserInfo<Engine>( "engine", "type of engine" ),
		producer( "producer"),
		consumption( "consumption")
	{
		producer.Attach( attributes );
		consumption.Attach( attributes );
	}

	Engine* build()
	{		
		return new Engine( producer.value, consumption.value );
	}
};


class Car
{
public:
	string color;
	int year;
	Engine engine;

	Car( string color, int year, Engine engine)
		: color( color ),
		year( year ),
		engine( engine )
	{
	}
};

//! User info for strings
class CarUI : public UserInfo<Car> 
{
public:
	EngineUI engine;

	StringAttribute color;
	IntAttribute year;

	CarUI()
		: UserInfo<Car>("car", "type of a car"), 
		color( "color"), 
		year( "color" )
	{
		engine.Attach( elements );

		color.Attach( attributes );
		year.Attach( attributes );
	}

	Car* build()
	{		
		Engine* pEng = engine.build();
		return new Car(color.value, year.value,*pEng);
	}
};


int main()
{
	CarUI car;

	car.Save( "car.xml" );	

/*
	car.Load( "car.xml" );
	Car *pDefaultCar = car.build();
	cout << "our car has " << pDefaultCar->color << " color";
	delete pDefaultCar;
// */

	getchar();
	return 0;
}

