
/*!
\file
\brief Robust
\author Vasek Smidl 

 */

#include "robustlib.h"
#include <vector>
#include <iostream>
#include <fstream>

using namespace itpp;
//using namespace bdm;

const int emlig_size = 2;


int main ( int argc, char* argv[] ) {
	
	/*
	// EXPERIMENT: 100 AR model generated time series of length of 30 from y_t=0.95*y_(t-1)+0.05*y_(t-2)+0.2*e_t, 
	// where e_t is normally, student(4) and cauchy distributed are tested using robust AR model, to obtain the 
	// variance of location parameter estimators and compare it to the classical setup.
	vector<vector<vector<string>>> string_lists;
	string_lists.push_back(vector<vector<string>>());
	string_lists.push_back(vector<vector<string>>());
	string_lists.push_back(vector<vector<string>>());

	char* file_strings[3] = {"c:\\ar_normal.txt", "c:\\ar_student.txt", "c:\\ar_cauchy.txt"};
	

	for(int i = 0;i<3;i++)
	{	
		ifstream myfile(file_strings[i]);
		if (myfile.is_open())
		{
			while ( myfile.good() )
			{
				string line;
				getline(myfile,line);
				
				vector<string> parsed_line;
				while(line.find(',') != string::npos)
				{
					int loc = line.find(',');
					parsed_line.push_back(line.substr(0,loc));
					line.erase(0,loc+1);					
				}				

				string_lists[i].push_back(parsed_line);
			}
			myfile.close();
		}
	}

	for(int j = 0;j<string_lists.size();j++)
	{ 
		
		for(int i = 0;i<string_lists[j].size()-1;i++)
		{
			vector<vec> conditions;
			//emlig* emliga = new emlig(2);
			RARX* my_rarx = new RARX(2,30);

			for(int k = 1;k<string_lists[j][i].size();k++)
			{
				vec condition;
				//condition.ins(0,1);				
				condition.ins(0,string_lists[j][i][k]);				
				conditions.push_back(condition);

				//cout << "orig:" << condition << endl;

				if(conditions.size()>1)
				{		
					conditions[k-2].ins(0,string_lists[j][i][k]);
					
				}

				if(conditions.size()>2)
				{
					conditions[k-3].ins(0,string_lists[j][i][k]);

					//cout << "modi:" << conditions[k-3] << endl;

					my_rarx->bayes(conditions[k-3]);

					
					//if(k>5)
					//{
					//	cout << "MaxLik coords:" << emliga->minimal_vertex->get_coordinates() << endl;
					//}
					
				}				
				
			}

			//emliga->step_me(0);
			/*
			ofstream myfile;
			myfile.open("c:\\robust_ar1.txt",ios::app);
			myfile << my_rarx->minimal_vertex->get_coordinates()[0] << ";";
			myfile.close();

			myfile.open("c:\\robust_ar2.txt",ios::app);
			myfile << emliga->minimal_vertex->get_coordinates()[1] << ";";
			myfile.close();
			

			cout << "MaxLik coords:" << emliga->minimal_vertex->get_coordinates() << endl;
			cout << "Step: " << i << endl;
		}

		cout << "One experiment finished." << endl;

		ofstream myfile;
		myfile.open("c:\\robust_ar1.txt",ios::app);
		myfile << endl;
		myfile.close();

		myfile.open("c:\\robust_ar2.txt",ios::app);
		myfile << endl;
		myfile.close();
	}*/
    
	
	// EXPERIMENT: A moving window estimation and prediction of RARX is tested on data generated from 
    // y_t=0.95*y_(t-1)+0.05*y_(t-2)+0.2*e_t, where e_t is normally, student(4) and cauchy distributed. It
    // can be compared to the classical setup.
	

	vector<vector<string>> strings;

	char* file_strings[3] = {"c:\\ar_student_single.txt", "c:\\ar_cauchy_single.txt","c:\\ar_normal_single.txt"};

	for(int i = 0;i<3;i++)
	{			
		ifstream myfile(file_strings[i]);
		if (myfile.is_open())
		{			
			string line;
			getline(myfile,line);
				
			vector<string> parsed_line;
			while(line.find(',') != string::npos)
			{
				int loc = line.find(',');
				parsed_line.push_back(line.substr(0,loc));
				line.erase(0,loc+1);					
			}				

			strings.push_back(parsed_line);
			
			myfile.close();
		}
	}
	
	for(int j = 0;j<strings.size();j++)
	{ 		
		vector<vec> conditions;
		//emlig* emliga = new emlig(2);
		RARX* my_rarx = new RARX(2,0);

		for(int k = 1;k<170;k++)
		{
			vec condition;
			//condition.ins(0,1);				
			condition.ins(0,strings[j][k]);				
			conditions.push_back(condition);

			//cout << "orig:" << condition << endl;

			if(conditions.size()>1)
			{		
				conditions[k-2].ins(0,strings[j][k]);
					
			}

			if(conditions.size()>2)
			{
				conditions[k-3].ins(0,strings[j][k]);

				// cout << "modi:" << conditions[k-3] << endl;

				my_rarx->bayes(conditions[k-3]);

					
				
				if(k>5)
				{
					cout << "MaxLik coords:" << my_rarx->posterior->minimal_vertex->get_coordinates() << endl;

					ofstream myfile;
					char fstring[80];
					strcpy(fstring,file_strings[j]);
					strcat(fstring,"_res.txt");

					myfile.open(fstring,ios::app);
					myfile << my_rarx->posterior->minimal_vertex->get_coordinates()[0];
					if(k!=strings[j].size()-1)
					{
						myfile << ",";
					}
					else
					{
						myfile << endl;
					}
					myfile.close();
				}
					
			}	
			
			//emliga->step_me(0);
			/*
			ofstream myfile;
			myfile.open("c:\\robust_ar1.txt",ios::app);
			myfile << my_rarx->minimal_vertex->get_coordinates()[0] << ";";
			myfile.close();

			myfile.open("c:\\robust_ar2.txt",ios::app);
			myfile << emliga->minimal_vertex->get_coordinates()[1] << ";";
			myfile.close();
			

			cout << "MaxLik coords:" << emliga->minimal_vertex->get_coordinates() << endl;
			cout << "Step: " << i << endl;*/
		}
	}
		
		/*
		cout << "One experiment finished." << endl;

		ofstream myfile;
		myfile.open("c:\\robust_ar1.txt",ios::app);
		myfile << endl;
		myfile.close();

		myfile.open("c:\\robust_ar2.txt",ios::app);
		myfile << endl;
		myfile.close();*/
	

	//emlig* emlig1 = new emlig(emlig_size);

	//emlig1->step_me(0);
	//emlig* emlig2 = new emlig(emlig_size);
	
	/*
	emlig1->set_correction_factors(4);

	for(int j = 0;j<emlig1->correction_factors.size();j++)
	{
		for(set<my_ivec>::iterator vec_ref = emlig1->correction_factors[j].begin();vec_ref!=emlig1->correction_factors[j].end();vec_ref++)
		{
			cout << j << "    ";
			
			for(int i=0;i<(*vec_ref).size();i++)
			{
				cout << (*vec_ref)[i];
			}

			cout << endl;
		}
	}*/
	
	/*
    vec condition5 = "1.0 1.0 1.01";//"-0.3 1.7 1.5";

	emlig1->add_condition(condition5);
	//emlig1->step_me(0);


	vec condition1a = "-1.0 1.02 0.5";
	//vec condition1b = "1.0 1.0 1.01";
	emlig1->add_condition(condition1a);
	//emlig2->add_condition(condition1b);

	vec condition2a = "-0.3 1.7 1.5";
	//vec condition2b = "-1.0 1.0 1.0";
	emlig1->add_condition(condition2a);
	//emlig2->add_condition(condition2b);

	vec condition3a = "0.5 -1.01 1.0";
	//vec condition3b = "0.5 -1.01 1.0";

	emlig1->add_condition(condition3a);
	//emlig2->add_condition(condition3b);	

	vec condition4a = "-0.5 -1.0 1.0";
	//vec condition4b = "-0.5 -1.0 1.0";	

	emlig1->add_condition(condition4a);
	//cout << "************************************************" << endl;
	//emlig2->add_condition(condition4b);
	//cout << "************************************************" << endl;
	
	//cout << emlig1->minimal_vertex->get_coordinates();
	
	//emlig1->remove_condition(condition3a);
	//emlig1->step_me(0);
	//emlig1->remove_condition(condition2a);
	//emlig1->remove_condition(condition1a);
	//emlig1->remove_condition(condition5);
	

	//emlig1->step_me(0);
	//emlig2->step_me(0);
	

	// DA SE POUZIT PRO VYPIS DO SOUBORU
	// emlig1->step_me(0);

	//emlig1->remove_condition(condition1);
	
	

	
	
	/*
	for(int i = 0;i<100;i++)
	{
		cout << endl << "Step:" << i << endl;		

		double condition[emlig_size+1];		

		for(int k = 0;k<=emlig_size;k++)
		{
			condition[k] = (rand()-RAND_MAX/2)/1000.0;		
		}
			

		vec* condition_vec = new vec(condition,emlig_size+1);
		emlig1->add_condition(*condition_vec);

		/*
		for(polyhedron* toprow_ref = emlig1->statistic.rows[emlig_size]; toprow_ref != emlig1->statistic.end_poly; toprow_ref = toprow_ref->next_poly)
		{
			cout << ((toprow*)toprow_ref)->probability << endl;
		}
		*/
		/*
		cout << emlig1->statistic_rowsize(emlig_size) << endl << endl;
	
		/*
		if(i-emlig1->number_of_parameters >= 0)
		{
			pause(30);
		}
		*/

		// emlig1->step_me(i);
		
		/*
		vector<int> sizevector;
		for(int s = 0;s<=emlig1->number_of_parameters;s++)
		{
			sizevector.push_back(emlig1->statistic_rowsize(s));
		}
		*/
	//}
    


	
	/*
	emlig1->step_me(1);

	vec condition = "2.0 0.0 1.0";	

	emlig1->add_condition(condition);

	vector<int> sizevector;
	for(int s = 0;s<=emlig1->number_of_parameters;s++)
	{
		sizevector.push_back(emlig1->statistic_rowsize(s));
	}

	emlig1->step_me(2);

	condition = "2.0 1.0 0.0";

	emlig1->add_condition(condition);

	sizevector.clear();
	for(int s = 0;s<=emlig1->number_of_parameters;s++)
	{
		sizevector.push_back(emlig1->statistic_rowsize(s));
	}
	*/

	return 0;
}



