/****************************************

	Parametry synchronniho motoru s permanentnimi magnety

	Definice zakl. parametru pro Pn=5.9kW

	Z. Peroutka

Rev.	10.9.2007

Pohon NFR

- cidlo proudu Imax=55A -> 50A
10.9.2007	zmena reference proudu z Iref=12*sqrt(2) na Iref=30*sqrt(2)
			zmena reference momentu z Mref=17.8 na Mref=34
			zmena reference toku z Fref=1 na Fref=Fmag=0.1989
******************************************/

// pri pouziti Q13 se za vztazne hodnoty voli jmenovite hodnoty

#define Uref		(600.0   *4)
#define Iref		((30.0*1.4142)  *4)
#define Wref		((6.283185*200.)  *4)
#define Thetaref	3.141593
#define	Mref		(34.0 *4)
#define Fref		(0.1989 * 4)

#define Qm		15		// veliciny motoru jsou v presnosti Qm

// parametry cidel - maximalni hodnoty (Xmax) ... vyuzivano v modulu ADC
#define Imax	50.0
#define Umax	662.5		// 662.5 / 442.5 / 222.5

#define K_I_p	(Imax/Iref)	// zesileni cidel proudu
#define K_U_p	(Umax/Uref)	// zesileni cidel napeti

#define Q_K_I	14			// system pro zesileni cidel proudu (konst. K_I)
#define Q_K_U	14			// system pro zesileni cidel napeti (konst. K_U)

// maximalni proud motoru, pri kterem se menic vypina - porucha
#define Isfault		(48.0/Iref)
#define Ucmax_fault	(650.0/Uref)
