/*!
\file
\brief wrapper function for epdf.covariance()


 */

#include <stat/emix.h>

using namespace bdm;

#ifdef MEX
#include <mex/mex_parser.h>
#include <mex/mex_pdf.h>

void mexFunction ( int n_output, mxArray *output[], int n_input, const mxArray *input[] ) {
	// Check the number of inputs and output arguments
	if ( n_input<1 ) mexErrMsgTxt ( "Usage:\n"
		                                "vec=pdf_variance(pdf_struct)\n"
		                                "  pdf_struct = struct('class','pdf_offspring',...);  % description of pdf\n"
		                                "output:\n"
		                                "  vec variance of given pdf." );

	RV::clear_all();
	//CONFIG
	UImxArray Cfg(input[0]);
// 	Cfg.writeFile("epdf_covariance.cfg");

	shared_ptr<epdf> ep=UI::build<epdf>(Cfg);

	if (ep) {
		output[0] = mxCreateDoubleMatrix(ep->dimension(), ep->dimension(), mxREAL);
		mat2mxArray(ep->covariance(), output[0]);
	} else { 
		mexErrMsgTxt ( "Given object is not epdf" );
	}
	
}
#endif
