function [ztrata H]=lqg_control(system, apriori,regulator_parameters)
horizont=system.horizont_rizeni;
ztrata=0;

H=zeros(horizont+1,size(apriori.H,1),size(apriori.H,2));
u=zeros(2,horizont+1);
H(1,:,:)=apriori.H;

for i=1:horizont
    H0(:,:)=H(i,:,:);
    u(:,i)=simple_control(system,H0(:,1), regulator_parameters.horizont_simulace);
    system.x=get_next(system,system.x_skutecne,u(:,i));
    H1=kalman_filter(H0,u(:,i),system);
    H(i+1,:,:)=H1;
    ztrata=ztrata+(H1(:,1)-system.x_optimalni)'*system.ksi*(H1(:,1)-system.x_optimalni)+u(:,i)'*system.gamma*u(:,i);
end
end

