function [H,C]=init_hyperstate(n_grid, apriori, mode)
switch(mode)
    case(0)
        C=zeros(1,n_grid);
        step=apriori.beta0_range/(n_grid-1)*2;
        min=apriori.beta0-apriori.beta0_range;
        max=apriori.beta0+apriori.beta0_range;
        H=min:step:max;  
    case(1)
        C=zeros(1,n_grid);
        a=0:1/(n_grid-1):1;
        min=apriori.beta0-apriori.beta0_range;
        max=apriori.beta0+apriori.beta0_range;
        H=(max-min)/(exp(1)-1)*exp(a)+(exp(1)*min-max)/(exp(1)-1);
    case(2)
        [H C]=load_H;
end
end


