/*!
  \file
  \brief Bayesian Filtering for linear Gaussian models (Kalman Filter) and extensions
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef EKF_TEMPLATE_H
#define EKF_TEMPLATE_H

#include "kalman.h"

namespace bdm {

//!Extended Kalman filter with unknown \c Q and \c R
class EKFful_unQR : public EKFfull  {
public:
    void condition ( const vec &QR0 ) {
        Q = diag ( QR0 ( 0, dimension() - 1 ) );
        R = diag ( QR0 ( dimension(), dimension() + dimy - 1 ) );
    };
};

//!Extended Kalman filter in Choleski form with unknown diagonal \c Q
class EKFCh_dQ : public EKFCh {
public:
    root* _copy_() const {
        return new EKFCh_dQ(*this);
    }

    //! new bayes, expects cond = [ut, Qt]
    void bayes( const vec &yt , const vec &cond) {
        vec ut=cond.left(dimc-dimension());
        vec dQt=cond.right(dimension());
        Q.setD ( dQt, 0 );
        //from EKF
        preA.set_submatrix ( dimy + dimension(), dimy, Q._Ch() );

        EKFCh::bayes(yt,ut);
    };
    void validate() {
        EKFCh::validate();
        dimc += dimension();
    }
};

//!Extended Kalman filter in Choleski form with unknown \c Q
class EKFCh_chQ : public EKFCh {
public:
    void condition ( const vec &chQ0 ) {
        Q.setCh ( chQ0 );
        //from EKF
        preA.set_submatrix ( dimy + dimension(), dimension(), Q._Ch() );
    };
};

////!Extended Kalman filter with unknown parameters in \c IM
// class EKFCh_cond : public EKFCh  {
// public:
// 	void condition ( const vec &val ) {
// 		pfxu->condition ( val );
// 	};
// };

}
#endif //EKF_TEMP_H
