
/*!
\file
\brief Robust
\author Vasek Smidl 

 */

//<<<<<<< .mine
#include "trading_models_lib.h"
#include <iostream> 
#include "estim/arx.h"
//=======
#include "trading_models_lib.h"
#include "estim/arx.h"
#include <vector>
#include <string>
#include <sstream>
#include <fstream>


//>>>>>>> .r1284
using namespace bdm;

/*
string cislo(string s)   // tato procedura spracova tie cisla z toho textoveho suboru tak aby sa odstranilo to e-001 a boli v spravnom 
						//formate. Lebo predtym to vyhadyovalo divne cisla, nevedel som ci je to zato, ze bayes si  stym neporadi, ale yjavne nepomohlo
{
	int b=s.find('e');
	string t=s.substr(0,b);
	string poz=s.substr(b+1,s.size());

	istringstream g(poz);
	int pozc;
	g>>pozc;
	istringstream k(t);
	double csl;
	k>>csl;
	if (pozc<0) //pozc moze byt niekedy aj kladne
	{
		for(int i=1;i<=-pozc;i++)
		csl/=10;
	} else
	{ 
		for(int j=1;j<=pozc;j++)
		csl*=10;
	}
	
	ostringstream o;
	o<<csl;
	return o.str();
} */

double sumastlpec(int k,vector<vec> pole,vector<vec> pravd) {  //robi sumu k-teho stlpca, pouzivam na konci pri ratani pravdepodobnosti
	double r=0;
	for (int i=0;i<pole.size();i++)
	{
		r+=pole[i][k]*pravd[i][k];
	}
	return r;
		}

int main () {
	vector<vector<string>> ADdata;     //nacitavanie dat do pola ADdata -funguje spravne
		ifstream myfile("C:\\AD_dataupravene.txt");
		if (myfile.is_open())
		{
			while ( myfile.good() )
			{
				string line;
				getline(myfile,line);
				vector<string> parsed_line;				 
				while(line.find(' ') != string::npos) //jeden kanal je jeden riadok, na zaciatku a na konci {,}, data oddelene ciarkou a medzerou.
				{
					line.erase(0,1);   //toto nie je yrovna peknz sposob,ale pri poslednom nacitani cisla v riadku sme uz nemali ziadnu medyeru a cyklus by sa posledny krat nevykonal, tak tu medzeru odstranujeme vzdy tu
					int loc = line.find(',');   //ale pri poslednom cisla to nenajde ziadnu ciaarku, tak potom co prida do parsed_line?
					parsed_line.push_back(line.substr(0,loc));	
					line.erase(0,loc+1);				//odstranujeme ciarku za kazdym cislom
				}				
				ADdata.push_back(parsed_line); //3927 dat v riadku, 6 riadkov
			}
		}
		myfile.close();  //konec nacitavania dat

		vector<vec> norm; //do norm zapisujeme normalizacne faktory
		for (int h=1;h<=2;h++) //cyklus ktory ovplzvnuje konstantu h=1- model s konstantou, h=2, bez konstanty
		{ 
			bool b;			//b pouzivame pri set_constant
			if(h==2)
				b=false;   
			else
				b=true;
			int g=2;
			while (g<=4)  //cyklus co meni rozmery matice V
			{
				mat V0 = 0.0001 * eye ( g ); // aj tato matica ma vplyv na normalizacny faktor, nemoze byt aj preto taky velky, ako inak by sa dala zvolit?
				
				int p=0;
				while (p<=1)  //tento cyklus prechadza vacsinou len raz, vtedy p=0 a nic to neovplvni, ale pri AR(2) modely to bude vykonavat 2 krat aj pre p=1, ked bude brat do condition aj rozne kanale z toho isteho casu 
				{
					int i=0;
					while(i < ADdata.size()-p) //niekedy sa ten cyklus ma vykonat len raz, preto nepouzivam for cyklus
					{	
						int j=p*(i+1); //j=0 alebo j=i+1
					
						while(j < ADdata.size())
						{
							ARX Ar;
							Ar.set_statistics ( 1, V0 ); //nu is default (set to have finite moments)
							Ar.set_constant ( b );
							Ar.validate();	// forgetting is default: 1.0
							vec pomocka;  //pri kazdej jednej hypoteze zapisujeme normalizacne faktory do pomocky, tu potom ako riadok pridame do norm
							for(int k = 0;k<341;k++) //prechadyame "po riadkoch", teda v case. Nejake hodnoty su len po index 340, dalej uz #INF000
							{
								vec condition;	
								vec predikce;
								predikce.ins(0,ADdata[3][k+2]);			//predpovede nacitavame a zadavame do Bayes zvlast
								condition.ins(0,ADdata[i][k+1]);					
								condition.ins(0,ADdata[j][k+p]);//zmena i -> j aby to bralo regresory z roznych riadkov, ak p=1 bereme data z toho isteho casu
								
								cout << "Pred:" << predikce << ", ";
								cout << "Cond:" << condition << endl;
								
								Ar.bayes(predikce,condition.right(g+h-3));	//z condition berem len urcity pocet prvkov, bud 0, 1,alebo 2, lebo nepotrebujem vzdy vsetky (AR(1) model)					
								pomocka.ins(pomocka.size(),Ar.posterior().lognc()); //nie je tu exponenciala! -aby to bolo mensie
							}  					
							norm.push_back(pomocka);  
							if ((g==3 && h==2) || (g==4))  //tento cyklus sa bude opakovat, len ak mame maticu V0 roymeru 4x4, to je AR(2) model s konst, alebo podobne len g=3, h=2, teda AR(2)bez kons
							{
								j++;
							} else
							{
								j=ADdata.size();	//priradenim tejto hodnoty do j sa cyklus uz viac krat nevykona
							}
						}
						if (b==true && g==2) //pre model AR(0) s konstantou robi tento cyklus len raz, v ostatnych pripadoch viac-krat
						{
							i=ADdata.size();
						} else
						{
							i++;
						}
					}
					if ((g==3 && h==2) || (g==4) )
					{p++;} else {p=2;}
				}
				if (h==2 && g==3) //pripad g=4, a konstanta zaroven nas uz nezaujima, vtedy to ukoncime
				{
					g=5; //ak priradime takuto hodnotu, cyklus while sa uz nevykona
				} else
				{
					g++;
				}
			}
		}

		/*  //tu je to povodne
		mat V0 = 0.0001 * eye ( 2 );  //pre pripad samotnej konstanty
		ARX Ar;
		Ar.set_statistics ( 1, V0 ); //nu is default (set to have finite moments)
		Ar.set_constant ( true );
		Ar.validate();			// forgetting is default: 1.0
		vector<double> pom1;
		for(int k = 0;k<140;k++) //prechadyame "po riadkoch" 
			{
				vec predikce;
				vec cond;
				cond.ins(0,ADdata[3][3]);
				predikce.ins(0,ADdata[3][k+2]);			//predpovede nacitavame a zadavame do Bayes zvlast
				Ar.bayes(predikce,cond.right(0));					
				pom1.push_back(exp(Ar.posterior().lognc()));
			}  
		norm.push_back(pom1);  
		
		for (int a=2;a<=3;a++)  //AR(1) bez a potom s konstantou
		{
			bool b=false;			//b pouzivame pri set_constant
			if(a==3)
				b=true;
			mat V0 = 0.0001 * eye ( a );  //pre pripad samotnej konstanty
			
			for (int p=0;p < ADdata.size();p++)
			{
				ARX Ar;
				Ar.set_statistics ( 1, V0 ); //nu is default (set to have finite moments)
				Ar.set_constant ( b );
				Ar.validate();			// forgetting is default: 1.0
				vector<double> pom1;
				for(int k = 0;k<140;k++) //prechadyame "po riadkoch" 
				{
					vec predikce;
					vec condition;
					condition.ins(0,ADdata[p][k]);
					predikce.ins(0,ADdata[3][k+1]);			//predpovede nacitavame a zadavame do Bayes zvlast
					Ar.bayes(predikce,condition);					
					pom1.push_back(exp(Ar.posterior().lognc()));
				}  
				norm.push_back(pom1);  //normalizacne faktory pre urcitu kombinaciu regresorov(teda po kazdom riadku) ulozi do pola norm
			}
		}
		
		
		for (int g=3;g<=4;g++)  //tento cyklus je az do konca, raz to robime s konstantou, raz bez.
		{
			bool b;			//b pouzivame pri set_constant
			if(g==3)
				b=false;   
			else
				b=true;
			mat V0 = 0.0001 * eye ( g );
			for(int i = 0;i < ADdata.size();i++) //po pocet riadkov, co bz malo byt 6
			{
				for(int j = i+1; j<ADdata.size();j++)
				{
					ARX Ar;
					Ar.set_statistics ( 1, V0 ); //nu is default (set to have finite moments)
					Ar.set_constant ( b );
					Ar.validate();
							// forgetting is default: 1.0
					vector<double> pomocka;
					for(int k = 0;k<140;k++) //prechadyame "po riadkoch" 
					{
						vec condition;	
						vec predikce;
						predikce.ins(0,ADdata[3][k+1]);			//predpovede nacitavame a zadavame do Bayes zvlast
						condition.ins(0,ADdata[i][k]);						
						condition.ins(0,ADdata[j][k]);//zmena i -> j qby to bralo regresory z roznych riadkov			
						Ar.bayes(predikce,condition);					
						pomocka.push_back(exp(Ar.posterior().lognc()));
					}  					
					norm.push_back(pomocka);  
				}
			}		
			for(int i = 0;i < ADdata.size();i++) //po pocet riadkov, co bz malo byt 6
			{
				for(int j = 0; j<ADdata.size();j++)
				{
					ARX Ar;
					Ar.set_statistics ( 1, V0 ); //nu is default (set to have finite moments)
					Ar.set_constant ( b );
					Ar.validate();
							// forgetting is default: 1.0
					vector<double> pomocka;
					for(int k = 0;k<140;k++) //prechadyame "po riadkoch" 
					{
						vec condition;	
						vec predikce;
						predikce.ins(0,ADdata[3][k+2]);			//predpovede nacitavame a zadavame do Bayes zvlast
						condition.ins(0,ADdata[i][k]); 
						
						condition.ins(0,ADdata[j][k+1]);//zmena i -> j qby to bralo regresory z roznych riadkov			
						Ar.bayes(predikce,condition);					
						pomocka.push_back(Ar.posterior().lognc());
					}  
					
					norm.push_back(pomocka);  
				}
			}
		}*/
			vector<vec> prsti; //hypotez je 85
			int m,n,p;
			for(p=0;p<115;p++) //inicializuem apriorne pravdepodobnosti
			{
				vec k;
				k.ins(0,1/115.);
				prsti.push_back(k);
			}
			// v ramci riadku v poli norm su hodnoty pre jednu hypotezu v roznych casoch, pocitanie pravdepodobnosti z norm. faktorov
			for (m=0;m<norm[1].size();m++) 
			{	double k=sumastlpec(m,norm,prsti);
				for(n=0;n < norm.size();n++)
				{
					prsti[n].ins(prsti[n].size(),norm[n][m]*prsti[n][m]/k);				
				}
			}		
			ofstream file;	//zapis pravdepodobnosti do suboru
			file.open("prsti_hypot.txt");
			for(int i=0;i < prsti.size();i++)
			{
				for(int j=0;j < prsti[i].size();j++)
				{
					if(j!=prsti[i].size()-1)
					{
						file << prsti[i][j]<<" ";
					}else
					{
						file<<prsti[i][j]<<endl;
					}					
				}
			}
			file<<endl;
			file.close();
		
	}


	