%> @file mexLaplace.m
%> @brief Matrlab implemnetation of Laplace density
% ======================================================================
%> @brief Unconditional Laplace density
%
%> \f[ f(x|\mu,b) \propto \exp(-|x-\mu|/b)\f]
% ======================================================================
classdef mexLaplace < mexEpdf
    properties
      % from wikipedia
    	mu
    	b
    end
    methods
        function m=mean(obj)
            m = obj.mu;
        end
        function obj=validate(obj)
            if length(obj.mu)~=length(obj.b)
                error('incompatible mu and b');
            end
        end
        function dim=dimension(obj)
            dim = size(obj.mu,1);
        end
        function v=variance(obj)
            v=2*obj.b^2;
        end
        function l=evallog(obj,x)
            l=-log(2*obj.b)-abs(x-obj.mu)/obj.b;
        end
        function s=sample(obj)
            v=-log(rand);%sample_exponential(0,1);
            z = randn;
            s = obj.mu+obj.b*sqrt(2*v)*z;
        end
    end
end