classdef mexMultiNomBM < mexBM
    properties
        PYX;                               % Probability of tran
        PXX;                               %  
        apost_pdf = mexMultiNom;           % posterior density in the form of MultiNom
        p0;
    end
    methods
        function obj=validate(obj)                            % prepare all internal objects for use
            % check alpha
            % check beta
            obj.apost_pdf = mexMultiNom;
            % check p0
            obj.apost_pdf.p = obj.p0;
            obj.log_evidence = 0;                             % evidence is not computed!
        end

        function dims=dimensions(obj)
            %please fill: dims = [size_of_posterior size_of_data size_of_condition]
            dims = [1,1,0];                                    % we have: [1d parameters, 1d observations, 1d condition]
        end
        function obj=bayes(obj,yd,cond)                       % approximate bayes rule
           
           p = obj.apost_pdf.p;
           PYX = obj.PYX;
           PXX = obj.PXX;

           nvalx = size(p,1);

           k=yd;

           %choice from the table for the output

           a=PYX(:,k);


           %non-normalized probability
           for l=1:nvalx
               p(l)=PXX(1:end,l)'*diag(a)*p(:);

           end

           %normalization
           p(:)=p(:)/sum(p(:));

           obj.apost_pdf.p=p;
        end
    end

end