function H=kalman_filter(H0,u,system)
H=H0;
A=[system.a 0 system.b*sin(H(4,1)) system.b*H(3,1)*cos(H(4,1)) 
   0 system.a -system.b*cos(H(4,1)) system.b*H(3,1)*sin(H(4,1)) 
   -system.e*sin(H(4,1)) system.e*cos(H(4,1)) system.d -system.e*(H(2,1)*sin(H(4,1)) +H(1,1)*cos(H(4,1)))
   0 0 system.deltat 1];

P=A*H(:,2:5)*A'+system.Q;
R=system.C*P*system.C'+system.R;
K=P*system.C'*inv(R);
predikce=get_next(system,H0(:,1),u);
H(:,1)=predikce+K*(system.x([1 2])-predikce([1 2]));
H(:,2:5)=P-P*system.C'*inv(R)*system.C*P;
end

