function [best_control system]=simple_control(system,x_hat)
omegar=system.x_opt(3);

i_d=x_hat(1)*cos(x_hat(4))+x_hat(2)*sin(x_hat(4));
i_q=x_hat(2)*cos(x_hat(4))-x_hat(1)*sin(x_hat(4));

[i_q_bar system]=PI_controler(omegar-x_hat(3),system,1);
[u_d system]=PI_controler(-i_d,system,2);
[u_q system]=PI_controler(i_q_bar-i_q,system,3);

u_d=u_d-0.003465*x_hat(3)*i_q_bar;
u_q=u_q+0.1989*x_hat(3);

U=sqrt(u_d^2+u_q^2);
fi=atan(u_q/u_d)+x_hat(4);
if u_d<0
    fi=fi+pi;
end

best_control(1,1) = U*cos(fi);
best_control(2,1) = U*sin(fi);

%best_control(1,1) = 1;
%best_control(2,1) = 1;

n=best_control'*best_control;
if n>100
    best_control=best_control*sqrt(100/n);
end
end