function [system,apriori,regulator_parameters, compare_parameters]=nastav
eps=0.001;

%parametry systemu
system.P=[1 20 20];
system.I=[0.00375 0.5 0.5];
system.S=zeros(1,3);

system.a=0.9898;
system.b=0.0072;
system.c=0.0361;
system.d=1;
system.e=0.0149;
system.deltat=0.000125;
system.Q=diag([0.0013,0.0013,5*10^(-6),10^(-10)],0);
system.R=diag([0.0006,0.0006],0);
system.ksi=[0 0 0 0
            0 0 0 0
            0 0 1 0
            0 0 0 0];
          v=0.1;
system.gamma=[v 0
              0 v];
system.B=[system.c 0
          0 system.c
          0 0
          0 0];
system.C=[1 0 0 0
          0 1 0 0];   
system.horizont_rizeni=500;
system.x_opt=[0; 0; 1.1; 0];
system.x=[0; 0; 0.5; pi/4];
system.pozorovani=[0 0];

%apriorni informace
apriori.H=[0 0.01 0 0 0
           0 0 0.01 0 0
           0.5 0 0 0.1 0
           0 0 0 0 10];
apriori.Hmin=[-0.5 0.01 0 0 0
              -0.5 0 0.01 0 0
              0.3 0 0 0.01 0
              0 0 0 0 0.01];
apriori.Hmax=[0.5 0.01 0 0 0
              0.5 0 0.01 0 0
              1.3 0 0 0.5 0
              2*pi 0 0 0 10];


%parametry regulatoru
regulator_parameters.horizont_simulace=20;
regulator_parameters.H_tilde_on=[0 0 0 0 0
                                 0 0 0 0 0
                                 0 0 0 0 0
                                 0 0 0 0 1]; %H=[x_hat S]
regulator_parameters.n_iter=8;
regulator_parameters.num_of_candidates=7;
regulator_parameters.generate_candidates_mode='norm';
regulator_parameters.search_region_init=3;
regulator_parameters.gama=0.4;
regulator_parameters.n_grid=10;


system.H_tilde_on=regulator_parameters.H_tilde_on;
%Parametry RSSS
compare_parameters.n0=20;
compare_parameters.delta=0; %nevim
compare_parameters.alpha=0.05;
compare_parameters.on=0;

end